/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.tools;

import fr.inra.adonis.editeurgraphique.model.Connection;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.tools.ObjectSelectionUtil;
import fr.inra.adonis.icons.IconsRegistry;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.AbstractBloc;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.projetDeSaisie.cheminement.CheminementCalcule;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;

public final class ConnectionsUtil {
    private ConnectionsUtil() {
    }

    public static void createConnectionsGraphique(ObjetMetierPart root, CheminementCalcule cheminementCalcule) {
        root.removeAllConnections();
        EList individus = cheminementCalcule.getObjets();
        if (individus != null && individus.size() > 0) {
            ObjetMetier tempInd = (ObjetMetier)individus.get(0);
            int i = 0;
            HashMap<ObjetMetier, ObjetMetierPart> cacheObjetPart = new HashMap<ObjetMetier, ObjetMetierPart>();
            HashSet<ObjetMetier> cacheObjetMetierWithNoPart = new HashSet<ObjetMetier>();
            for (ObjetMetier ind : individus) {
                ObjetMetierPart og1 = ConnectionsUtil.getEditPart(root, tempInd, cacheObjetPart, cacheObjetMetierWithNoPart);
                ObjetMetierPart og2 = ConnectionsUtil.getEditPart(root, ind, cacheObjetPart, cacheObjetMetierWithNoPart);
                if (og1 != null && i == 0) {
                    og1.setImage(IconsRegistry.IMG_POSITION_COURANTE);
                }
                if (og1 != null && og2 != null && !EcoreUtil.equals((EObject)((ObjetMetier)og1.getModel()), (EObject)((ObjetMetier)og2.getModel()))) {
                    Connection con = new Connection(og1, og2, 1);
                    con.connect();
                }
                tempInd = ind;
                ++i;
            }
        }
    }

    private static ObjetMetierPart getEditPart(ObjetMetierPart root, ObjetMetier objetToFind, HashMap<ObjetMetier, ObjetMetierPart> cacheObjetPart, HashSet<ObjetMetier> cacheObjetMetierWithNoPart) {
        if (cacheObjetMetierWithNoPart.contains(objetToFind)) {
            return null;
        }
        ObjetMetierPart og1 = cacheObjetPart.get(objetToFind);
        if (og1 == null) {
            EObject parent = objetToFind.eContainer();
            while (parent != null && (parent instanceof AbstractBloc || parent instanceof ParcelleUnitaire)) {
                ObjetMetierPart parentPart = cacheObjetPart.get(parent);
                if (parentPart != null) {
                    root = parentPart;
                    break;
                }
                parent = parent.eContainer();
            }
            og1 = (ObjetMetierPart)ObjectSelectionUtil.parcoursEditParts((EditPart)root, objetToFind);
            if (og1 != null) {
                ObjetMetierPart objPartToadd = og1;
                while (objPartToadd != null && !cacheObjetPart.containsKey((Object)objPartToadd)) {
                    cacheObjetPart.put((ObjetMetier)objPartToadd.getModel(), objPartToadd);
                    if (objPartToadd.getParent() == null || !(objPartToadd.getParent() instanceof ObjetMetierPart)) break;
                    objPartToadd = (ObjetMetierPart)objPartToadd.getParent();
                }
                cacheObjetPart.get(parent);
            } else {
                cacheObjetMetierWithNoPart.add(objetToFind);
            }
        }
        return og1;
    }
}

