/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.tools;

import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.AbstractBloc;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.modeleMetier.plateforme.UniteDeParcours;
import fr.inra.adonis.modeleMetier.plateforme.ZheAvecEpaisseur;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public final class ObjectSelectionUtil {
    public static ObjetMetier selectParent(GraphicalViewer graphicalViewer, Class<?> classObjectToCreate) {
        ObjetMetier objSelected = null;
        StructuredSelection selection = (StructuredSelection)graphicalViewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            objSelected = (ObjetMetier)((ObjetMetierPart)((Object)selection.getFirstElement())).getModel();
        }
        ObjetMetier parent = null;
        if (classObjectToCreate == Individu.class) {
            if (objSelected != null) {
                parent = DispositifUtil.getParent((ObjetMetier)objSelected, ParcelleUnitaire.class);
            }
        } else if (classObjectToCreate == ParcelleUnitaire.class) {
            if (objSelected != null) {
                parent = DispositifUtil.getParent((ObjetMetier)objSelected, AbstractBloc.class);
            }
        } else if (classObjectToCreate == SousBloc.class) {
            if (objSelected != null) {
                parent = DispositifUtil.getParent((ObjetMetier)objSelected, Bloc.class);
            }
        } else if (classObjectToCreate == Bloc.class) {
            if (objSelected != null) {
                parent = DispositifUtil.getParent((ObjetMetier)objSelected, Dispositif.class);
            }
        } else if (classObjectToCreate == ZheAvecEpaisseur.class && objSelected != null) {
            parent = DispositifUtil.getParent((ObjetMetier)objSelected, UniteDeParcours.class);
        }
        if (parent != null) {
            RootEditPart root = graphicalViewer.getRootEditPart();
            EditPart parentPart = ObjectSelectionUtil.parcoursEditParts((EditPart)root, parent);
            graphicalViewer.setSelection((ISelection)new StructuredSelection((Object)parentPart));
        }
        return parent;
    }

    public static EditPart parcoursEditParts(EditPart root, ObjetMetier modelTarget) {
        if (root == null || modelTarget == null) {
            return null;
        }
        if (root.getModel() == modelTarget) {
            return root;
        }
        for (Object child : root.getChildren()) {
            EditPart res = ObjectSelectionUtil.parcoursEditParts((EditPart)child, modelTarget);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private ObjectSelectionUtil() {
    }
}

