/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.wizard.filtres;

import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.editeurgraphique.wizard.filtres.AbstractTableViewer;
import fr.inra.adonis.editeurgraphique.wizard.filtres.IndividusColumnLabelProvider;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.ChampOptionnel;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.plateforme.TypeUniteParcours;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;

public class IndividusTableViewer
extends AbstractTableViewer {
    private final List<ChampOptionnel> champsOptionnels = new ArrayList<ChampOptionnel>();
    private boolean modeSurfacique = false;

    public IndividusTableViewer(Composite parent, int style, ObjetMetier root) {
        super(parent, style);
        if (root instanceof Plateforme) {
            for (Dispositif dispo : ((Plateforme)root).getDispositifs()) {
                this.modeSurfacique = this.modeSurfacique || dispo.isPuSurfacique();
                this.champsOptionnels.addAll((Collection<ChampOptionnel>)dispo.getChampsOptionnels());
            }
        } else {
            Dispositif dispo = DispositifUtil.getDispositifFrom((EObject)root);
            if (dispo != null) {
                this.modeSurfacique = dispo.isPuSurfacique();
                this.champsOptionnels.addAll((Collection<ChampOptionnel>)dispo.getChampsOptionnels());
            }
        }
        this.createTitles();
        this.createColumns(parent);
    }

    private void createTitles() {
        int base = 11;
        if (this.modeSurfacique) {
            base -= 2;
        }
        int nbChampsOpt = this.champsOptionnels.size();
        this.titles = new String[base + nbChampsOpt];
        this.bounds = new Integer[base + nbChampsOpt];
        int i = 0;
        this.titles[i] = "Dispositif";
        this.bounds[i] = 50;
        this.titles[++i] = "Bloc";
        this.bounds[i] = 50;
        this.titles[++i] = "SousBloc";
        this.bounds[i] = 50;
        ++i;
        if (!this.modeSurfacique) {
            this.titles[i] = "Parcelle";
            this.bounds[i] = 50;
            ++i;
        }
        this.titles[i] = "Traitement (long)";
        this.bounds[i] = 100;
        this.titles[++i] = "Traitement (court)";
        this.bounds[i] = 50;
        this.titles[++i] = "X";
        this.bounds[i] = 50;
        this.titles[++i] = "Y";
        this.bounds[i] = 50;
        this.titles[++i] = "Mort";
        this.bounds[i] = 50;
        this.titles[++i] = "Anomalie";
        this.bounds[i] = 50;
        ++i;
        if (!this.modeSurfacique) {
            this.titles[i] = "Maille vide";
            this.bounds[i] = 50;
            ++i;
        }
        for (ChampOptionnel champ : this.champsOptionnels) {
            this.titles[i] = champ.getNom();
            this.bounds[i] = 50;
            ++i;
        }
    }

    @Override
    protected void assignColumnLabelProvider(TableViewerColumn col, int colIndex) {
        col.setLabelProvider((CellLabelProvider)new IndividusColumnLabelProvider(this.titles[colIndex], colIndex, this.champsOptionnels));
    }

    @Override
    public TypeUniteParcours getTypeUniteParcours() {
        return TypeUniteParcours.INDIVIDU;
    }
}

