/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.SimpleCell;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.markup.MarkupParser;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class Table
extends Rectangle
implements Element,
MarkupAttributes {
    private int columns;
    private Point curPosition = new Point(0, 0);
    private ArrayList rows = new ArrayList();
    private Cell defaultLayout = new Cell(true);
    private int lastHeaderRow = -1;
    private int alignment = 1;
    private float cellpadding;
    private float cellspacing;
    private float widthPercentage = 80.0f;
    private String absWidth = "";
    private float[] widths;
    boolean mDebug = false;
    boolean mTableInserted = false;
    boolean mAutoFillEmptyCells = false;
    boolean tableFitsPage = false;
    boolean cellsFitPage = false;
    float offset = Float.NaN;
    protected Hashtable alternatingRowAttributes = null;
    protected boolean convert2pdfptable = false;
    private static DecimalFormat widthFormat = new DecimalFormat("0.00");
    static /* synthetic */ Class class$com$lowagie$text$Table;
    static /* synthetic */ Class class$com$lowagie$text$Cell;

    public Table(int n) throws BadElementException {
        this(n, 1);
    }

    public Table(int n, int n2) throws BadElementException {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(15);
        this.setBorderWidth(1.0f);
        this.defaultLayout.setBorder(15);
        if (n <= 0) {
            throw new BadElementException("A table should have at least 1 column.");
        }
        this.columns = n;
        for (int i = 0; i < n2; ++i) {
            this.rows.add(new Row(n));
        }
        this.curPosition = new Point(0, 0);
        this.widths = new float[n];
        float f = 100.0f / (float)n;
        for (int i = 0; i < n; ++i) {
            this.widths[i] = f;
        }
    }

    public Table(Properties properties) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        int n;
        int n2;
        int n3;
        int n4;
        this.setBorder(15);
        this.setBorderWidth(1.0f);
        this.defaultLayout.setBorder(15);
        String string = (String)properties.remove("columns");
        if (string == null) {
            this.columns = 1;
        } else {
            this.columns = Integer.parseInt(string);
            if (this.columns <= 0) {
                this.columns = 1;
            }
        }
        this.rows.add(new Row(this.columns));
        this.curPosition.setLocation(0, this.curPosition.y);
        string = (String)properties.remove("lastHeaderRow");
        if (string != null) {
            this.setLastHeaderRow(Integer.parseInt(string));
        }
        if ((string = (String)properties.remove("align")) != null) {
            this.setAlignment(string);
        }
        if ((string = (String)properties.remove("cellspacing")) != null) {
            this.setSpacing(Float.parseFloat(string + "f"));
        }
        if ((string = (String)properties.remove("cellpadding")) != null) {
            this.setPadding(Float.parseFloat(string + "f"));
        }
        if ((string = (String)properties.remove("offset")) != null) {
            this.setOffset(Float.parseFloat(string + "f"));
        }
        if ((string = (String)properties.remove("width")) != null) {
            if (string.endsWith("%")) {
                this.setWidth(Float.parseFloat(string.substring(0, string.length() - 1) + "f"));
            } else {
                this.setAbsWidth(string);
            }
        }
        this.widths = new float[this.columns];
        for (n4 = 0; n4 < this.columns; ++n4) {
            this.widths[n4] = 0.0f;
        }
        string = (String)properties.remove("widths");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            int n5 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                this.widths[n5] = Float.parseFloat(string + "f");
                ++n5;
            }
            this.columns = n5;
        }
        if ((string = (String)properties.remove("tablefitspage")) != null) {
            this.tableFitsPage = Boolean.valueOf(string);
        }
        if ((string = (String)properties.remove("cellsfitpage")) != null) {
            this.cellsFitPage = Boolean.valueOf(string);
        }
        if ((string = (String)properties.remove("convert2pdfp")) != null) {
            this.convert2pdfptable = Boolean.valueOf(string);
        }
        if ((string = (String)properties.remove("borderwidth")) != null) {
            this.setBorderWidth(Float.parseFloat(string + "f"));
        }
        n4 = 0;
        string = (String)properties.remove("left");
        if (string != null && Boolean.valueOf(string).booleanValue()) {
            n4 |= 4;
        }
        if ((string = (String)properties.remove("right")) != null && Boolean.valueOf(string).booleanValue()) {
            n4 |= 8;
        }
        if ((string = (String)properties.remove("top")) != null && Boolean.valueOf(string).booleanValue()) {
            n4 |= 1;
        }
        if ((string = (String)properties.remove("bottom")) != null && Boolean.valueOf(string).booleanValue()) {
            n4 |= 2;
        }
        this.setBorder(n4);
        String string2 = (String)properties.remove("red");
        String string3 = (String)properties.remove("green");
        String string4 = (String)properties.remove("blue");
        if (string2 != null || string3 != null || string4 != null) {
            n3 = 0;
            n2 = 0;
            n = 0;
            if (string2 != null) {
                n3 = Integer.parseInt(string2);
            }
            if (string3 != null) {
                n2 = Integer.parseInt(string3);
            }
            if (string4 != null) {
                n = Integer.parseInt(string4);
            }
            this.setBorderColor(new Color(n3, n2, n));
        } else {
            string = properties.getProperty("bordercolor");
            if (string != null) {
                this.setBorderColor(MarkupParser.decodeColor(string));
            }
        }
        string2 = (String)properties.remove("bgred");
        string3 = (String)properties.remove("bggreen");
        string4 = (String)properties.remove("bgblue");
        if (string2 != null || string3 != null || string4 != null) {
            n3 = 0;
            n2 = 0;
            n = 0;
            if (string2 != null) {
                n3 = Integer.parseInt(string2);
            }
            if (string3 != null) {
                n2 = Integer.parseInt(string3);
            }
            if (string4 != null) {
                n = Integer.parseInt(string4);
            }
            this.setBackgroundColor(new Color(n3, n2, n));
        } else {
            string = (String)properties.remove("backgroundcolor");
            if (string != null) {
                this.setBackgroundColor(MarkupParser.decodeColor(string));
            }
        }
        string = (String)properties.remove("grayfill");
        if (string != null) {
            this.setGrayFill(Float.parseFloat(string + "f"));
        }
        if (properties.size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public void setDebug(boolean bl) {
        this.mDebug = bl;
    }

    public void setDefaultLayout(Cell cell) {
        this.defaultLayout = cell;
    }

    public void setAutoFillEmptyCells(boolean bl) {
        this.mAutoFillEmptyCells = bl;
    }

    public void setTableFitsPage(boolean bl) {
        this.tableFitsPage = bl;
        if (bl) {
            this.setCellsFitPage(true);
        }
    }

    public void setCellsFitPage(boolean bl) {
        this.cellsFitPage = bl;
    }

    public boolean hasToFitPageTable() {
        return this.tableFitsPage;
    }

    public boolean hasToFitPageCells() {
        return this.cellsFitPage;
    }

    public void setOffset(float f) {
        this.offset = f;
    }

    public float getOffset() {
        return this.offset;
    }

    public int type() {
        return 22;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public void addCell(Cell cell, int n, int n2) throws BadElementException {
        this.addCell(cell, new Point(n, n2));
    }

    public void addCell(Cell cell, Point point) throws BadElementException {
        if (cell == null) {
            throw new NullPointerException("addCell - cell has null-value");
        }
        if (point == null) {
            throw new NullPointerException("addCell - point has null-value");
        }
        if (cell.isTable()) {
            this.insertTable((Table)cell.getElements().next(), point);
        }
        if (this.mDebug) {
            if (point.x < 0) {
                throw new BadElementException("row coordinate of location must be >= 0");
            }
            if (point.y <= 0 && point.y > this.columns) {
                throw new BadElementException("column coordinate of location must be >= 0 and < nr of columns");
            }
            if (!this.isValidLocation(cell, point)) {
                throw new BadElementException("Adding a cell at the location (" + point.x + "," + point.y + ") with a colspan of " + cell.colspan() + " and a rowspan of " + cell.rowspan() + " is illegal (beyond boundaries/overlapping).");
            }
        }
        if (cell.border() == -1) {
            cell.setBorder(this.defaultLayout.border());
        }
        cell.fill();
        this.placeCell(this.rows, cell, point);
        this.setCurrentLocationToNextValidPosition(point);
    }

    public void addCell(Cell cell) {
        try {
            this.addCell(cell, this.curPosition);
        }
        catch (BadElementException badElementException) {
            // empty catch block
        }
    }

    public void addCell(Phrase phrase) throws BadElementException {
        this.addCell(phrase, this.curPosition);
    }

    public void addCell(Phrase phrase, Point point) throws BadElementException {
        Cell cell = new Cell(phrase);
        cell.setBorder(this.defaultLayout.border());
        cell.setBorderWidth(this.defaultLayout.borderWidth());
        cell.setBorderColor(this.defaultLayout.borderColor());
        cell.setBackgroundColor(this.defaultLayout.backgroundColor());
        cell.setHorizontalAlignment(this.defaultLayout.horizontalAlignment());
        cell.setVerticalAlignment(this.defaultLayout.verticalAlignment());
        cell.setColspan(this.defaultLayout.colspan());
        cell.setRowspan(this.defaultLayout.rowspan());
        this.addCell(cell, point);
    }

    public void addCell(String string) throws BadElementException {
        this.addCell(new Phrase(string), this.curPosition);
    }

    public void addCell(String string, Point point) throws BadElementException {
        this.addCell(new Phrase(string), point);
    }

    public void insertTable(Table table) {
        if (table == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        this.insertTable(table, this.curPosition);
    }

    public void insertTable(Table table, int n, int n2) {
        if (table == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        this.insertTable(table, new Point(n, n2));
    }

    public void insertTable(Table table, Point point) {
        if (table == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        if (point == null) {
            throw new NullPointerException("insertTable - point has null-value");
        }
        this.mTableInserted = true;
        table.complete();
        if (this.mDebug && point.y > this.columns) {
            System.err.println("insertTable -- wrong columnposition(" + point.y + ") of location; max =" + this.columns);
        }
        int n = point.x + 1 - this.rows.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.rows.add(new Row(this.columns));
            }
        }
        ((Row)this.rows.get(point.x)).setElement(table, point.y);
        this.setCurrentLocationToNextValidPosition(point);
    }

    public void complete() {
        if (this.mTableInserted) {
            this.mergeInsertedTables();
            this.mTableInserted = false;
        }
        if (this.mAutoFillEmptyCells) {
            this.fillEmptyMatrixCells();
        }
        if (this.alternatingRowAttributes != null) {
            Properties properties = new Properties();
            Properties properties2 = new Properties();
            Object object = this.alternatingRowAttributes.keySet().iterator();
            while (object.hasNext()) {
                String string = String.valueOf(object.next());
                String[] stringArray = (String[])this.alternatingRowAttributes.get(string);
                properties.setProperty(string, stringArray[0]);
                properties2.setProperty(string, stringArray[1]);
            }
            for (int i = this.lastHeaderRow + 1; i < this.rows.size(); ++i) {
                object = (Row)this.rows.get(i);
                ((Row)object).setMarkupAttributes(i % 2 == 0 ? properties : properties2);
            }
        }
    }

    public void setDefaultCellBorder(int n) {
        this.defaultLayout.setBorder(n);
    }

    public void setDefaultCellBorderWidth(float f) {
        this.defaultLayout.setBorderWidth(f);
    }

    public void setDefaultCellBorderColor(Color color) {
        this.defaultLayout.setBorderColor(color);
    }

    public void setDefaultCellBackgroundColor(Color color) {
        this.defaultLayout.setBackgroundColor(color);
    }

    public void setDefaultCellGrayFill(float f) {
        if (f >= 0.0f && f <= 1.0f) {
            this.defaultLayout.setGrayFill(f);
        }
    }

    public void setDefaultHorizontalAlignment(int n) {
        this.defaultLayout.setHorizontalAlignment(n);
    }

    public void setDefaultVerticalAlignment(int n) {
        this.defaultLayout.setVerticalAlignment(n);
    }

    public void setDefaultRowspan(int n) {
        this.defaultLayout.setRowspan(n);
    }

    public void setDefaultColspan(int n) {
        this.defaultLayout.setColspan(n);
    }

    private void assumeTableDefaults(Cell cell) {
        if (cell.border() == -1) {
            cell.setBorder(this.defaultLayout.border());
        }
        if (cell.borderWidth() == -1.0f) {
            cell.setBorderWidth(this.defaultLayout.borderWidth());
        }
        if (cell.borderColor() == null) {
            cell.setBorderColor(this.defaultLayout.borderColor());
        }
        if (cell.backgroundColor() == null) {
            cell.setBackgroundColor(this.defaultLayout.backgroundColor());
        }
        if (cell.horizontalAlignment() == -1) {
            cell.setHorizontalAlignment(this.defaultLayout.horizontalAlignment());
        }
        if (cell.verticalAlignment() == -1) {
            cell.setVerticalAlignment(this.defaultLayout.verticalAlignment());
        }
    }

    public void deleteColumn(int n) throws BadElementException {
        float[] fArray = new float[--this.columns];
        System.arraycopy(this.widths, 0, fArray, 0, n);
        System.arraycopy(this.widths, n + 1, fArray, n, this.columns - n);
        this.setWidths(fArray);
        System.arraycopy(this.widths, 0, fArray, 0, this.columns);
        this.widths = fArray;
        int n2 = this.rows.size();
        for (int i = 0; i < n2; ++i) {
            Row row = (Row)this.rows.get(i);
            row.deleteColumn(n);
            this.rows.set(i, row);
        }
        if (n == this.columns) {
            this.curPosition.setLocation(this.curPosition.x + 1, 0);
        }
    }

    public boolean deleteRow(int n) {
        if (n < 0 || n >= this.rows.size()) {
            return false;
        }
        this.rows.remove(n);
        this.curPosition.setLocation(this.curPosition.x - 1, this.curPosition.y);
        return true;
    }

    public void deleteAllRows() {
        this.rows.clear();
        this.rows.add(new Row(this.columns));
        this.curPosition.setLocation(0, 0);
        this.lastHeaderRow = -1;
    }

    public boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public int endHeaders() {
        this.lastHeaderRow = this.curPosition.x - 1;
        return this.lastHeaderRow;
    }

    public void setLastHeaderRow(int n) {
        this.lastHeaderRow = n;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setAlignment(String string) {
        if ("Left".equalsIgnoreCase(string)) {
            this.alignment = 0;
            return;
        }
        if ("right".equalsIgnoreCase(string)) {
            this.alignment = 2;
            return;
        }
        this.alignment = 1;
    }

    public void setSpaceInsideCell(float f) {
        this.cellpadding = f;
    }

    public void setSpaceBetweenCells(float f) {
        this.cellspacing = f;
    }

    public void setPadding(float f) {
        this.cellpadding = f;
    }

    public void setSpacing(float f) {
        this.cellspacing = f;
    }

    public void setCellpadding(float f) {
        this.cellspacing = f;
    }

    public void setCellspacing(float f) {
        this.cellpadding = f;
    }

    public void setWidth(float f) {
        this.widthPercentage = f;
    }

    public void setAbsWidth(String string) {
        this.absWidth = string;
    }

    public void setWidths(float[] fArray) throws BadElementException {
        if (fArray.length != this.columns) {
            throw new BadElementException("Wrong number of columns.");
        }
        float f = 0.0f;
        for (int i = 0; i < this.columns; ++i) {
            f += fArray[i];
        }
        this.widths[this.columns - 1] = 100.0f;
        for (int i = 0; i < this.columns - 1; ++i) {
            float f2;
            this.widths[i] = f2 = 100.0f * fArray[i] / f;
            int n = this.columns - 1;
            this.widths[n] = this.widths[n] - f2;
        }
    }

    public void setWidths(int[] nArray) throws DocumentException {
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            fArray[i] = nArray[i];
        }
        this.setWidths(fArray);
    }

    public int columns() {
        return this.columns;
    }

    public int size() {
        return this.rows.size();
    }

    public float[] getProportionalWidths() {
        return this.widths;
    }

    public Iterator iterator() {
        return this.rows.iterator();
    }

    public int alignment() {
        return this.alignment;
    }

    public float cellpadding() {
        return this.cellpadding;
    }

    public float cellspacing() {
        return this.cellspacing;
    }

    public float widthPercentage() {
        return this.widthPercentage;
    }

    public String absWidth() {
        return this.absWidth;
    }

    public int firstDataRow() {
        return this.lastHeaderRow + 1;
    }

    public int lastHeaderRow() {
        return this.lastHeaderRow;
    }

    public Dimension getDimension() {
        return new Dimension(this.columns, this.rows.size());
    }

    public Object getElement(int n, int n2) {
        return ((Row)this.rows.get(n)).getCell(n2);
    }

    private void mergeInsertedTables() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        float[] fArray = null;
        int[] nArray = new int[this.columns];
        float[][] fArrayArray = new float[this.columns][];
        int[] nArray2 = new int[this.rows.size()];
        ArrayList<Row> arrayList = null;
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        Table table = null;
        for (n5 = 0; n5 < this.columns; ++n5) {
            n9 = 1;
            float[] fArray2 = null;
            for (n4 = 0; n4 < this.rows.size(); ++n4) {
                if (!(class$com$lowagie$text$Table == null ? Table.class$("com.lowagie.text.Table") : class$com$lowagie$text$Table).isInstance(((Row)this.rows.get(n4)).getCell(n5))) continue;
                bl = true;
                table = (Table)((Row)this.rows.get(n4)).getCell(n5);
                if (fArray2 == null) {
                    fArray2 = table.widths;
                    n9 = fArray2.length;
                    continue;
                }
                n3 = table.getDimension().width;
                float[] fArray3 = new float[n3 * fArray2.length];
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                n2 = 0;
                n = 0;
                int n10 = 0;
                f += fArray2[0];
                f2 += table.widths[0];
                while (n2 < fArray2.length && n < n3) {
                    if (f2 > f) {
                        fArray3[n10] = f - f3;
                        if (++n2 < fArray2.length) {
                            f += fArray2[n2];
                        }
                    } else {
                        fArray3[n10] = f2 - f3;
                        ++n;
                        if ((double)Math.abs(f2 - f) < 1.0E-4 && ++n2 < fArray2.length) {
                            f += fArray2[n2];
                        }
                        if (n < n3) {
                            f2 += table.widths[n];
                        }
                    }
                    f3 += fArray3[n10];
                    ++n10;
                }
                fArray2 = new float[n10];
                System.arraycopy(fArray3, 0, fArray2, 0, n10);
                n9 = n10;
            }
            fArrayArray[n5] = fArray2;
            n7 += n9;
            nArray[n5] = n9;
        }
        for (n4 = 0; n4 < this.rows.size(); ++n4) {
            n8 = 1;
            for (n5 = 0; n5 < this.columns; ++n5) {
                if (!(class$com$lowagie$text$Table == null ? Table.class$("com.lowagie.text.Table") : class$com$lowagie$text$Table).isInstance(((Row)this.rows.get(n4)).getCell(n5))) continue;
                bl = true;
                table = (Table)((Row)this.rows.get(n4)).getCell(n5);
                if (table.getDimension().height <= n8) continue;
                n8 = table.getDimension().height;
            }
            n6 += n8;
            nArray2[n4] = n8;
        }
        if (n7 != this.columns || n6 != this.rows.size() || bl) {
            fArray = new float[n7];
            int n11 = 0;
            for (n3 = 0; n3 < this.widths.length; ++n3) {
                if (nArray[n3] != 1) {
                    for (int i = 0; i < nArray[n3]; ++i) {
                        fArray[n11] = this.widths[n3] * fArrayArray[n3][i] / 100.0f;
                        ++n11;
                    }
                    continue;
                }
                fArray[n11] = this.widths[n3];
                ++n11;
            }
            arrayList = new ArrayList<Row>(n6);
            for (n4 = 0; n4 < n6; ++n4) {
                arrayList.add(new Row(n7));
            }
            n3 = 0;
            int n12 = 0;
            Object object = null;
            for (n4 = 0; n4 < this.rows.size(); ++n4) {
                n12 = 0;
                n8 = 1;
                for (n5 = 0; n5 < this.columns; ++n5) {
                    Object object2;
                    if ((class$com$lowagie$text$Table == null ? Table.class$("com.lowagie.text.Table") : class$com$lowagie$text$Table).isInstance(((Row)this.rows.get(n4)).getCell(n5))) {
                        table = (Table)((Row)this.rows.get(n4)).getCell(n5);
                        object2 = new int[table.widths.length + 1];
                        n2 = 0;
                        for (int i = 0; i < table.widths.length; ++i) {
                            object2[i] = n12 + n2;
                            float f = table.widths[i];
                            float f4 = 0.0f;
                            while (n2 < nArray[n5]) {
                                f4 += fArrayArray[n5][n2++];
                                if (!(Math.abs(Table.convertWidth(f) - Table.convertWidth(f4)) < 1.0E-4)) continue;
                            }
                        }
                        object2[i] = n12 + n2;
                        for (n = 0; n < table.getDimension().height; ++n) {
                            for (int i = 0; i < table.getDimension().width; ++i) {
                                object = table.getElement(n, i);
                                if (object == null) continue;
                                Object object3 = n12 + i;
                                if ((class$com$lowagie$text$Cell == null ? Table.class$("com.lowagie.text.Cell") : class$com$lowagie$text$Cell).isInstance(object)) {
                                    Cell cell = (Cell)object;
                                    object3 = object2[i];
                                    Object object4 = object2[i + cell.colspan()];
                                    cell.setColspan((int)(object4 - object3));
                                }
                                ((Row)arrayList.get(n + n3)).addElement(object, (int)object3);
                            }
                        }
                    } else if ((class$com$lowagie$text$Cell == null ? Table.class$("com.lowagie.text.Cell") : class$com$lowagie$text$Cell).isInstance(object2 = this.getElement(n4, n5))) {
                        ((Cell)object2).setRowspan(((Cell)((Row)this.rows.get(n4)).getCell(n5)).rowspan() + nArray2[n4] - 1);
                        ((Cell)object2).setColspan(((Cell)((Row)this.rows.get(n4)).getCell(n5)).colspan() + nArray[n5] - 1);
                        this.placeCell(arrayList, (Cell)object2, new Point(n3, n12));
                    }
                    n12 += nArray[n5];
                }
                n3 += nArray2[n4];
            }
            this.columns = n7;
            this.rows = arrayList;
            this.widths = fArray;
        }
    }

    private void fillEmptyMatrixCells() {
        try {
            for (int i = 0; i < this.rows.size(); ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    if (((Row)this.rows.get(i)).isReserved(j)) continue;
                    this.addCell(this.defaultLayout, new Point(i, j));
                }
            }
        }
        catch (BadElementException badElementException) {
            throw new ExceptionConverter(badElementException);
        }
    }

    private boolean isValidLocation(Cell cell, Point point) {
        if (point.x < this.rows.size()) {
            if (point.y + cell.colspan() > this.columns) {
                return false;
            }
            int n = this.rows.size() - point.x > cell.rowspan() ? cell.rowspan() : this.rows.size() - point.x;
            int n2 = this.columns - point.y > cell.colspan() ? cell.colspan() : this.columns - point.y;
            for (int i = point.x; i < point.x + n; ++i) {
                for (int j = point.y; j < point.y + n2; ++j) {
                    if (!((Row)this.rows.get(i)).isReserved(j)) continue;
                    return false;
                }
            }
        } else if (point.y + cell.colspan() > this.columns) {
            return false;
        }
        return true;
    }

    private void placeCell(ArrayList arrayList, Cell cell, Point point) {
        int n;
        Row row = null;
        int n2 = ((Row)arrayList.get(0)).columns();
        int n3 = point.x + cell.rowspan() - arrayList.size();
        this.assumeTableDefaults(cell);
        if (point.x + cell.rowspan() > arrayList.size()) {
            for (n = 0; n < n3; ++n) {
                row = new Row(n2);
                arrayList.add(row);
            }
        }
        for (n = point.x + 1; n < point.x + cell.rowspan(); ++n) {
            if (((Row)arrayList.get(n)).reserve(point.y, cell.colspan())) continue;
            throw new RuntimeException("addCell - error in reserve");
        }
        row = (Row)arrayList.get(point.x);
        row.addElement(cell, point.y);
    }

    public void addColumns(int n) {
        int n2;
        ArrayList<Row> arrayList = new ArrayList<Row>(this.rows.size());
        int n3 = this.columns + n;
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = new Row(n3);
            for (n2 = 0; n2 < this.columns; ++n2) {
                row.setElement(((Row)this.rows.get(i)).getCell(n2), n2);
            }
            for (n2 = this.columns; n2 < n3 && i < this.curPosition.x; ++n2) {
                row.setElement(this.defaultLayout, n2);
            }
            arrayList.add(row);
        }
        float[] fArray = new float[n3];
        System.arraycopy(this.widths, 0, fArray, 0, this.columns);
        for (n2 = this.columns; n2 < n3; ++n2) {
            fArray[n2] = 0.0f;
        }
        this.columns = n3;
        this.widths = fArray;
        this.rows = arrayList;
    }

    public float[] getWidths(float f, float f2) {
        float[] fArray = new float[this.columns + 1];
        switch (this.alignment) {
            case 0: {
                fArray[0] = f;
                break;
            }
            case 2: {
                fArray[0] = f + f2 * (100.0f - this.widthPercentage) / 100.0f;
                break;
            }
            default: {
                fArray[0] = f + f2 * (100.0f - this.widthPercentage) / 200.0f;
            }
        }
        f2 = f2 * this.widthPercentage / 100.0f;
        for (int i = 1; i < this.columns; ++i) {
            fArray[i] = fArray[i - 1] + this.widths[i - 1] * f2 / 100.0f;
        }
        fArray[this.columns] = fArray[0] + f2;
        return fArray;
    }

    private void setCurrentLocationToNextValidPosition(Point point) {
        int n = point.x;
        int n2 = point.y;
        do {
            if (n2 + 1 == this.columns) {
                ++n;
                n2 = 0;
                continue;
            }
            ++n2;
        } while (n < this.rows.size() && n2 < this.columns && ((Row)this.rows.get(n)).isReserved(n2));
        this.curPosition = new Point(n, n2);
    }

    public static boolean isTag(String string) {
        return "table".equals(string);
    }

    public void setAlternatingRowAttribute(String string, String string2, String string3) {
        String[] stringArray;
        if (string2 == null || string3 == null) {
            throw new NullPointerException("MarkupTable#setAlternatingRowAttribute(): null values are not permitted.");
        }
        if (this.alternatingRowAttributes == null) {
            this.alternatingRowAttributes = new Hashtable();
        }
        if ((stringArray = (String[])this.alternatingRowAttributes.get(string)) == null) {
            stringArray = new String[]{string2, string3};
        }
        this.alternatingRowAttributes.put(string, stringArray);
    }

    public float top() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float bottom() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float left() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float right() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float top(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float bottom(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float left(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float right(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public void setTop(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public void setBottom(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public void setLeft(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public void setRight(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public int getNextRow() {
        return this.curPosition.x;
    }

    public int getNextColumn() {
        return this.curPosition.y;
    }

    private static final double convertWidth(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        try {
            String string = widthFormat.format(d);
            Number number = widthFormat.parse(string);
            return number.doubleValue();
        }
        catch (ParseException parseException) {
            throw new RuntimeException("Could not convert double to width for val:" + d);
        }
    }

    public PdfPTable createPdfPTable() throws BadElementException {
        if (!this.convert2pdfptable) {
            throw new BadElementException("No error, just an old style table");
        }
        this.setAutoFillEmptyCells(true);
        this.complete();
        PdfPTable pdfPTable = new PdfPTable(this.widths);
        pdfPTable.setTableEvent(SimpleTable.getDimensionlessInstance(this, this.cellspacing));
        pdfPTable.setHeaderRows(this.lastHeaderRow + 1);
        pdfPTable.setSplitLate(this.cellsFitPage);
        pdfPTable.setKeepTogether(this.tableFitsPage);
        if (!Float.isNaN(this.offset)) {
            pdfPTable.setSpacingBefore(this.offset);
        }
        pdfPTable.setHorizontalAlignment(this.alignment);
        if (this.absWidth.length() > 0) {
            try {
                pdfPTable.setTotalWidth(Float.parseFloat(this.absWidth));
            }
            catch (Exception exception) {
                try {
                    pdfPTable.setTotalWidth(Integer.parseInt(this.absWidth));
                }
                catch (Exception exception2) {
                    pdfPTable.setWidthPercentage(this.widthPercentage);
                }
            }
        } else {
            pdfPTable.setWidthPercentage(this.widthPercentage);
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            for (int i = 0; i < row.columns(); ++i) {
                PdfPCell pdfPCell;
                Element element = (Element)row.getCell(i);
                if (element == null) continue;
                if (element instanceof Table) {
                    pdfPCell = new PdfPCell(((Table)element).createPdfPTable());
                } else if (element instanceof Cell) {
                    pdfPCell = ((Cell)element).createPdfPCell();
                    pdfPCell.setPadding(this.cellpadding + this.cellspacing / 2.0f);
                    pdfPCell.setCellEvent(SimpleCell.getDimensionlessInstance((Cell)element, this.cellspacing));
                } else {
                    pdfPCell = new PdfPCell();
                }
                pdfPTable.addCell(pdfPCell);
            }
        }
        return pdfPTable;
    }

    public boolean isConvert2pdfptable() {
        return this.convert2pdfptable;
    }

    public void setConvert2pdfptable(boolean bl) {
        this.convert2pdfptable = bl;
    }
}

