/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.javascript;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.IScriptEngine;
import org.eclipse.birt.core.script.IScriptEngineFactory;
import org.eclipse.birt.report.engine.javascript.JavascriptEngine;
import org.eclipse.birt.report.engine.javascript.ScriptUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavascriptEngineFactory
implements IScriptEngineFactory {
    public static String SCRIPT_JAVASCRIPT = "javascript";
    public static final boolean USE_DYNAMIC_SCOPE = true;
    private static Logger logger = Logger.getLogger(JavascriptEngineFactory.class.getName());
    protected ScriptableObject rootScope;
    private Context context = Context.enter();

    public static void initMyFactory() {
        ContextFactory.initGlobal((ContextFactory)new MyFactory());
    }

    public JavascriptEngineFactory() {
        try {
            try {
                try {
                    this.context.setSecurityController(ScriptUtil.createSecurityController());
                }
                catch (Throwable throwable) {}
                this.rootScope = this.context.initStandardObjects();
                this.context.evaluateString((Scriptable)this.rootScope, "function registerGlobal( name, value) { _jsContext.registerGlobalBean(name, value); }", "<inline>", 0, null);
                this.context.evaluateString((Scriptable)this.rootScope, "function unregisterGlobal(name) { _jsContext.unregisterGlobalBean(name); }", "<inline>", 0, null);
            }
            catch (Exception ex) {
                this.rootScope = null;
                logger.log(Level.INFO, "Error occurs while initialze script scope", ex);
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    public IScriptEngine createScriptEngine() throws BirtException {
        return new JavascriptEngine(this, this.rootScope);
    }

    public String getScriptLanguage() {
        return SCRIPT_JAVASCRIPT;
    }

    public static void destroyMyFactory() {
        ContextFactory factory = ContextFactory.getGlobal();
        if (factory != null && factory instanceof MyFactory) {
            try {
                Class<?> factoryClass = Class.forName("org.mozilla.javascript.ContextFactory");
                Field field = factoryClass.getDeclaredField("hasCustomGlobal");
                field.setAccessible(true);
                field.setBoolean(factoryClass, false);
                field = factoryClass.getDeclaredField("global");
                field.setAccessible(true);
                field.set(factoryClass, new ContextFactory());
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class MyFactory
    extends ContextFactory {
        MyFactory() {
        }

        protected boolean hasFeature(Context cx, int featureIndex) {
            if (featureIndex == 7) {
                return true;
            }
            return super.hasFeature(cx, featureIndex);
        }
    }
}

