/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.group;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.group.GroupCalculator;

class NumericGroupCalculator
extends GroupCalculator {
    double doubleStartValue;
    private double firstValue = Double.MIN_VALUE;

    public NumericGroupCalculator(Object intervalStart, double intervalRange) throws BirtException {
        super(intervalStart, intervalRange);
        this.doubleStartValue = intervalStart == null ? 0.0 : DataTypeUtil.toDouble((Object)intervalStart);
    }

    public Object calculate(Object value) throws BirtException {
        double dValue = -1.0;
        if (value != null) {
            dValue = DataTypeUtil.toDouble((Object)value);
        }
        if (dValue < this.doubleStartValue) {
            if (this.firstValue == Double.MIN_VALUE) {
                this.firstValue = dValue;
            }
            return new Double(this.firstValue);
        }
        return new Double(this.doubleStartValue + Math.floor((dValue - this.doubleStartValue) / this.intervalRange) * this.intervalRange);
    }
}

