/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.PrintWriter;
import org.apache.derby.client.am.BatchUpdateException;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.CrossConverters;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SectionManager;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Statement;

public abstract class Agent {
    public SqlException accumulatedReadExceptions_ = null;
    private boolean enableBatchedExceptionTracking_;
    private int batchedExceptionLabelIndex_;
    private boolean[] batchedExceptionGenerated_;
    Connection connection_;
    public SectionManager sectionManager_ = null;
    public LogWriter logWriter_ = null;
    final CrossConverters crossConverters_;
    SqlException deferredException_;

    void checkForDeferredExceptions() throws SqlException {
        if (this.deferredException_ != null) {
            SqlException temp = this.deferredException_;
            this.deferredException_ = null;
            throw temp;
        }
    }

    public void accumulateDeferredException(SqlException e) {
        if (this.deferredException_ == null) {
            this.deferredException_ = e;
        } else {
            this.deferredException_.setNextException(e);
        }
    }

    protected Agent(Connection connection, LogWriter logWriter) {
        this.connection_ = connection;
        this.logWriter_ = logWriter;
        this.crossConverters_ = new CrossConverters(this);
    }

    protected void resetAgent(LogWriter logWriter) {
        this.accumulatedReadExceptions_ = null;
        this.enableBatchedExceptionTracking_ = false;
        this.batchedExceptionLabelIndex_ = 0;
        this.batchedExceptionGenerated_ = null;
        this.logWriter_ = logWriter;
        this.deferredException_ = null;
    }

    public void resetAgent(Connection connection, LogWriter logWriter, int loginTimeout, String server, int port) throws SqlException {
        this.resetAgent(logWriter);
        this.resetAgent_(logWriter, loginTimeout, server, port);
    }

    protected abstract void resetAgent_(LogWriter var1, int var2, String var3, int var4) throws SqlException;

    public final boolean loggingEnabled() {
        return !Configuration.traceSuspended__ && this.logWriter_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLogWriter(LogWriter logWriter) {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.logWriter_ != null) {
                this.logWriter_.close();
            }
            this.logWriter_ = logWriter;
        }
    }

    public final PrintWriter getLogWriter() {
        return this.logWriter_ == null ? null : this.logWriter_.printWriter_;
    }

    public abstract LogWriter newLogWriter_(PrintWriter var1, int var2);

    public final void accumulateReadException(SqlException e) {
        if (this.enableBatchedExceptionTracking_) {
            this.batchedExceptionGenerated_[this.batchedExceptionLabelIndex_] = true;
            this.labelAsBatchedException(e, this.batchedExceptionLabelIndex_);
        }
        if (this.accumulatedReadExceptions_ == null) {
            this.accumulatedReadExceptions_ = e;
        } else {
            this.accumulatedReadExceptions_.setNextException(e);
        }
    }

    public final void accumulateDisconnectException(DisconnectException e) {
        if (this.enableBatchedExceptionTracking_) {
            this.batchedExceptionGenerated_[this.batchedExceptionLabelIndex_] = true;
            this.labelAsBatchedException(e, this.batchedExceptionLabelIndex_);
        }
        if (this.accumulatedReadExceptions_ != null) {
            e.setNextException(this.accumulatedReadExceptions_);
        }
        this.accumulatedReadExceptions_ = null;
    }

    public final void accumulateChainBreakingReadExceptionAndThrow(DisconnectException e) throws DisconnectException {
        this.accumulateDisconnectException(e);
        this.markChainBreakingException_();
        throw e;
    }

    protected abstract void markChainBreakingException_();

    public abstract void checkForChainBreakingException_() throws SqlException;

    private final void enableBatchedExceptionTracking(int batchSize) {
        this.enableBatchedExceptionTracking_ = true;
        this.batchedExceptionGenerated_ = new boolean[batchSize];
        this.batchedExceptionLabelIndex_ = 0;
    }

    final void disableBatchedExceptionTracking() {
        this.enableBatchedExceptionTracking_ = false;
    }

    public final void setBatchedExceptionLabelIndex(int index) {
        this.batchedExceptionLabelIndex_ = index;
    }

    private final SqlException labelAsBatchedException(SqlException e, int index) {
        SqlException firstInChain = e;
        while (e != null) {
            e.setBatchPositionLabel(index);
            e = e.getNextException();
        }
        return firstInChain;
    }

    protected final void checkForExceptions() throws SqlException {
        if (this.accumulatedReadExceptions_ != null) {
            SqlException e = this.accumulatedReadExceptions_;
            this.accumulatedReadExceptions_ = null;
            throw e;
        }
    }

    final boolean batchUpdateExceptionGenerated() {
        return this.batchedExceptionGenerated_[this.batchedExceptionLabelIndex_];
    }

    public final void flow(Statement statement) throws SqlException {
        this.endWriteChain();
        this.flush_();
        this.beginReadChain(statement);
    }

    public final void flowBatch(Statement statement, int batchSize) throws SqlException {
        this.endBatchedWriteChain();
        this.flush_();
        this.beginBatchedReadChain(statement, batchSize);
    }

    public final void flowOutsideUOW() throws SqlException {
        this.endWriteChain();
        this.flush_();
        this.beginReadChainOutsideUOW();
    }

    public abstract void flush_() throws DisconnectException;

    public abstract void close_() throws SqlException;

    public void close() throws SqlException {
        this.close_();
        if (this.logWriter_ != null) {
            this.logWriter_.close();
        }
    }

    public final void disconnectEvent() {
        try {
            this.close();
        }
        catch (SqlException sqlException) {
            // empty catch block
        }
        this.connection_.completeChainBreakingDisconnect();
    }

    public void beginWriteChainOutsideUOW() throws SqlException {
    }

    public void beginWriteChain(Statement statement) throws SqlException {
        this.connection_.writeTransactionStart(statement);
    }

    public final void beginBatchedWriteChain(Statement statement) throws SqlException {
        this.beginWriteChain(statement);
    }

    protected void endWriteChain() {
    }

    protected final void endBatchedWriteChain() {
    }

    protected void beginReadChain(Statement statement) throws SqlException {
        this.connection_.readTransactionStart();
    }

    protected final void beginBatchedReadChain(Statement statement, int batchSize) throws SqlException {
        this.enableBatchedExceptionTracking(batchSize);
        this.beginReadChain(statement);
    }

    protected void beginReadChainOutsideUOW() throws SqlException {
    }

    public void endReadChain() throws SqlException {
        this.checkForExceptions();
    }

    public final void endBatchedReadChain(int[] updateCounts, SqlException accumulatedExceptions) throws BatchUpdateException {
        this.disableBatchedExceptionTracking();
        for (int i = 0; i < this.batchedExceptionGenerated_.length; ++i) {
            if (!this.batchedExceptionGenerated_[i]) continue;
            updateCounts[i] = -3;
        }
        if (accumulatedExceptions == null) {
            try {
                this.endReadChain();
            }
            catch (SqlException e) {
                accumulatedExceptions = e;
            }
        }
        if (accumulatedExceptions != null) {
            throw new BatchUpdateException(this.logWriter_, new ClientMessageId("XJ208.S"), null, updateCounts, accumulatedExceptions);
        }
    }
}

