/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import org.apache.derby.client.am.CallableStatement;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.shared.common.error.ExceptionUtil;

class CallableLocatorProcedures {
    boolean isLocatorSupportAvailable = true;
    private CallableStatement blobCreateLocatorCall;
    private CallableStatement blobReleaseLocatorCall;
    private CallableStatement blobGetPositionFromLocatorCall;
    private CallableStatement blobGetPositionFromBytesCall;
    private CallableStatement blobGetLengthCall;
    private CallableStatement blobGetBytesCall;
    private CallableStatement blobSetBytesCall;
    private CallableStatement blobTruncateCall;
    private CallableStatement clobCreateLocatorCall;
    private CallableStatement clobReleaseLocatorCall;
    private CallableStatement clobGetPositionFromStringCall;
    private CallableStatement clobGetPositionFromLocatorCall;
    private CallableStatement clobGetLengthCall;
    private CallableStatement clobGetSubStringCall;
    private CallableStatement clobSetStringCall;
    private CallableStatement clobTruncateCall;
    private final Connection connection;
    private static final int VARCHAR_MAXWIDTH = 32672;
    private static final int INVALID_LOCATOR = -1;

    CallableLocatorProcedures(Connection conn) {
        this.connection = conn;
    }

    int blobCreateLocator() throws SqlException {
        if (!this.isLocatorSupportAvailable) {
            return -1;
        }
        try {
            if (this.blobCreateLocatorCall == null || !this.blobCreateLocatorCall.openOnClient_) {
                this.blobCreateLocatorCall = this.connection.prepareCallX("? = CALL SYSIBM.BLOBCREATELOCATOR()", 1003, 1007, this.connection.holdability());
                this.blobCreateLocatorCall.registerOutParameterX(1, 4);
                this.blobCreateLocatorCall.isAutoCommittableStatement_ = false;
            }
            this.blobCreateLocatorCall.executeX();
        }
        catch (SqlException sqle) {
            if (sqle.getSQLState().compareTo(ExceptionUtil.getSQLStateFromIdentifier("42Y03")) == 0) {
                this.isLocatorSupportAvailable = false;
                return -1;
            }
            throw sqle;
        }
        return this.blobCreateLocatorCall.getIntX(1);
    }

    void blobReleaseLocator(int locator) throws SqlException {
        if (this.blobReleaseLocatorCall == null || !this.blobReleaseLocatorCall.openOnClient_) {
            this.blobReleaseLocatorCall = this.connection.prepareCallX("CALL SYSIBM.BLOBRELEASELOCATOR(?)", 1003, 1007, 2);
            this.blobReleaseLocatorCall.isAutoCommittableStatement_ = false;
        }
        this.blobReleaseLocatorCall.setIntX(1, locator);
        try {
            this.blobReleaseLocatorCall.executeX();
        }
        catch (SqlException sqle) {
            sqle = this.handleInvalidLocator(sqle);
            throw sqle;
        }
    }

    long blobGetPositionFromLocator(int locator, int searchLocator, long fromPosition) throws SqlException {
        if (this.blobGetPositionFromLocatorCall == null || !this.blobGetPositionFromLocatorCall.openOnClient_) {
            this.blobGetPositionFromLocatorCall = this.connection.prepareCallX("? = CALL SYSIBM.BLOBGETPOSITIONFROMLOCATOR(?, ?, ?)", 1003, 1007, 2);
            this.blobGetPositionFromLocatorCall.registerOutParameterX(1, -5);
            this.blobGetPositionFromLocatorCall.isAutoCommittableStatement_ = false;
        }
        this.blobGetPositionFromLocatorCall.setIntX(2, locator);
        this.blobGetPositionFromLocatorCall.setIntX(3, searchLocator);
        this.blobGetPositionFromLocatorCall.setLongX(4, fromPosition);
        try {
            this.blobGetPositionFromLocatorCall.executeX();
        }
        catch (SqlException sqle) {
            sqle = this.handleInvalidLocator(sqle);
            throw sqle;
        }
        return this.blobGetPositionFromLocatorCall.getLongX(1);
    }

    long blobGetPositionFromBytes(int locator, byte[] searchLiteral, long fromPosition) throws SqlException {
        long blobLength = -1L;
        int patternLength = searchLiteral.length;
        do {
            long foundAt = this.blobGetPositionFromBytes(locator, fromPosition, searchLiteral, 0, 32672);
            boolean tryAgain = false;
            if (patternLength > 32672 && foundAt > 0L) {
                int numBytesThisRound;
                for (int comparedSoFar = 32672; comparedSoFar < patternLength; comparedSoFar += numBytesThisRound) {
                    numBytesThisRound = Math.min(patternLength - comparedSoFar, 32672);
                    long pos = this.blobGetPositionFromBytes(locator, foundAt + (long)comparedSoFar, searchLiteral, comparedSoFar, numBytesThisRound);
                    if (pos == foundAt + (long)comparedSoFar) continue;
                    tryAgain = true;
                    fromPosition = foundAt + 1L;
                    break;
                }
            }
            if (!tryAgain) {
                return foundAt;
            }
            if (blobLength >= 0L) continue;
            blobLength = this.blobGetLength(locator);
        } while (fromPosition + (long)patternLength <= blobLength);
        return -1L;
    }

    private long blobGetPositionFromBytes(int locator, long fromPosition, byte[] searchLiteral, int offset, int length) throws SqlException {
        if (this.blobGetPositionFromBytesCall == null || !this.blobGetPositionFromBytesCall.openOnClient_) {
            this.blobGetPositionFromBytesCall = this.connection.prepareCallX("? = CALL SYSIBM.BLOBGETPOSITIONFROMBYTES(?, ?, ?)", 1003, 1007, 2);
            this.blobGetPositionFromBytesCall.registerOutParameterX(1, -5);
            this.blobGetPositionFromBytesCall.isAutoCommittableStatement_ = false;
        }
        byte[] bytesToBeCompared = searchLiteral;
        int numBytes = Math.min(searchLiteral.length - offset, length);
        if (numBytes != bytesToBeCompared.length) {
            bytesToBeCompared = new byte[numBytes];
            System.arraycopy(searchLiteral, offset, bytesToBeCompared, 0, numBytes);
        }
        this.blobGetPositionFromBytesCall.setIntX(2, locator);
        this.blobGetPositionFromBytesCall.setBytesX(3, bytesToBeCompared);
        this.blobGetPositionFromBytesCall.setLongX(4, fromPosition);
        try {
            this.blobGetPositionFromBytesCall.executeX();
        }
        catch (SqlException sqle) {
            sqle = this.handleInvalidLocator(sqle);
            throw sqle;
        }
        return this.blobGetPositionFromBytesCall.getLongX(1);
    }

    long blobGetLength(int sourceLocator) throws SqlException {
        if (this.blobGetLengthCall == null || !this.blobGetLengthCall.openOnClient_) {
            this.blobGetLengthCall = this.connection.prepareCallX("? = CALL SYSIBM.BLOBGETLENGTH(?)", 1003, 1007, 2);
            this.blobGetLengthCall.registerOutParameterX(1, -5);
            this.blobGetLengthCall.isAutoCommittableStatement_ = false;
        }
        this.blobGetLengthCall.setIntX(2, sourceLocator);
        try {
            this.blobGetLengthCall.executeX();
        }
        catch (SqlException sqle) {
            sqle = this.handleInvalidLocator(sqle);
            throw sqle;
        }
        return this.blobGetLengthCall.getLongX(1);
    }

    byte[] blobGetBytes(int sourceLocator, long fromPosition, int forLength) throws SqlException {
        byte[] result;
        if (forLength == 0) {
            return new byte[0];
        }
        if (this.blobGetBytesCall == null || !this.blobGetBytesCall.openOnClient_) {
            this.blobGetBytesCall = this.connection.prepareCallX("? = CALL SYSIBM.BLOBGETBYTES(?, ?, ?)", 1003, 1007, 2);
            this.blobGetBytesCall.registerOutParameterX(1, -3);
            this.blobGetBytesCall.isAutoCommittableStatement_ = false;
        }
        byte[] retVal = null;
        for (int gotSoFar = 0; gotSoFar < forLength; gotSoFar += result.length) {
            this.blobGetBytesCall.setIntX(2, sourceLocator);
            this.blobGetBytesCall.setLongX(3, fromPosition + (long)gotSoFar);
            this.blobGetBytesCall.setIntX(4, forLength - gotSoFar);
            try {
                this.blobGetBytesCall.executeX();
            }
            catch (SqlException sqle) {
                sqle = this.handleInvalidLocator(sqle);
                throw sqle;
            }
            result = this.blobGetBytesCall.getBytesX(1);
            if (gotSoFar == 0) {
                if (result.length == forLength) {
                    return result;
                }
                retVal = new byte[forLength];
            }
            if (result.length == 0) break;
            System.arraycopy(result, 0, retVal, gotSoFar, result.length);
        }
        return retVal;
    }

    void blobSetBytes(int sourceLocator, long fromPosition, int forLength, byte[] bytes) throws SqlException {
        int numBytesThisRound;
        if (this.blobSetBytesCall == null || !this.blobSetBytesCall.openOnClient_) {
            this.blobSetBytesCall = this.connection.prepareCallX("CALL SYSIBM.BLOBSETBYTES(?, ?, ?, ?)", 1003, 1007, 2);
            this.blobSetBytesCall.isAutoCommittableStatement_ = false;
        }
        byte[] bytesToBeSent = bytes;
        for (int sentSoFar = 0; sentSoFar < forLength; sentSoFar += numBytesThisRound) {
            numBytesThisRound = Math.min(forLength - sentSoFar, 32672);
            if (numBytesThisRound != bytesToBeSent.length) {
                bytesToBeSent = new byte[numBytesThisRound];
            }
            if (bytesToBeSent != bytes) {
                System.arraycopy(bytes, sentSoFar, bytesToBeSent, 0, numBytesThisRound);
            }
            this.blobSetBytesCall.setIntX(1, sourceLocator);
            this.blobSetBytesCall.setLongX(2, fromPosition + (long)sentSoFar);
            this.blobSetBytesCall.setIntX(3, numBytesThisRound);
            this.blobSetBytesCall.setBytesX(4, bytesToBeSent);
            try {
                this.blobSetBytesCall.executeX();
                continue;
            }
            catch (SqlException sqle) {
                sqle = this.handleInvalidLocator(sqle);
                throw sqle;
            }
        }
    }

    void blobTruncate(int sourceLocator, long length) throws SqlException {
        if (this.blobTruncateCall == null || !this.blobTruncateCall.openOnClient_) {
            this.blobTruncateCall = this.connection.prepareCallX("CALL SYSIBM.BLOBTRUNCATE(?, ?)", 1003, 1007, 2);
            this.blobTruncateCall.isAutoCommittableStatement_ = false;
        }
        this.blobTruncateCall.setIntX(1, sourceLocator);
        this.blobTruncateCall.setLongX(2, length);
        try {
            this.blobTruncateCall.executeX();
        }
        catch (SqlException sqle) {
            sqle = this.handleInvalidLocator(sqle);
            throw sqle;
        }
    }

    int clobCreateLocator() throws SqlException {
        if (!this.isLocatorSupportAvailable) {
            return -1;
        }
        try {
            if (this.clobCreateLocatorCall == null || !this.clobCreateLocatorCall.openOnClient_) {
                this.clobCreateLocatorCall = this.connection.prepareCallX("? = CALL SYSIBM.CLOBCREATELOCATOR()", 1003, 1007, 2);
                this.clobCreateLocatorCall.registerOutParameterX(1, 4);
                this.clobCreateLocatorCall.isAutoCommittableStatement_ = false;
            }
            this.clobCreateLocatorCall.executeX();
        }
        catch (SqlException sqle) {
            if (sqle.getSQLState().compareTo(ExceptionUtil.getSQLStateFromIdentifier("42Y03")) == 0) {
                this.isLocatorSupportAvailable = false;
                return -1;
            }
            throw sqle;
        }
        return this.clobCreateLocatorCall.getIntX(1);
    }

    void clobReleaseLocator(int locator) throws SqlException {
        if (this.clobReleaseLocatorCall == null || !this.clobReleaseLocatorCall.openOnClient_) {
            this.clobReleaseLocatorCall = this.connection.prepareCallX("CALL SYSIBM.CLOBRELEASELOCATOR(?)", 1003, 1007, 2);
            this.clobReleaseLocatorCall.isAutoCommittableStatement_ = false;
        }
        this.clobReleaseLocatorCall.setIntX(1, locator);
        try {
            this.clobReleaseLocatorCall.executeX();
        }
        catch (SqlException sqle) {
            sqle = this.handleInvalidLocator(sqle);
            throw sqle;
        }
    }

    long clobGetPositionFromString(int locator, String searchLiteral, long fromPosition) throws SqlException {
        long clobLength = -1L;
        int patternLength = searchLiteral.length();
        do {
            long foundAt = this.clobGetPositionFromString(locator, fromPosition, searchLiteral, 0, 32672);
            boolean tryAgain = false;
            if (patternLength > 32672 && foundAt > 0L) {
                int numCharsThisRound;
                for (int comparedSoFar = 32672; comparedSoFar < patternLength; comparedSoFar += numCharsThisRound) {
                    numCharsThisRound = Math.min(patternLength - comparedSoFar, 32672);
                    long pos = this.clobGetPositionFromString(locator, foundAt + (long)comparedSoFar, searchLiteral, comparedSoFar, numCharsThisRound);
                    if (pos == foundAt + (long)comparedSoFar) continue;
                    tryAgain = true;
                    fromPosition = foundAt + 1L;
                    break;
                }
            }
            if (!tryAgain) {
                return foundAt;
            }
            if (clobLength >= 0L) continue;
            clobLength = this.clobGetLength(locator);
        } while (fromPosition + (long)patternLength <= clobLength);
        return -1L;
    }

    private long clobGetPositionFromString(int locator, long fromPosition, String searchLiteral, int offset, int length) throws SqlException {
        if (this.clobGetPositionFromStringCall == null || !this.clobGetPositionFromStringCall.openOnClient_) {
            this.clobGetPositionFromStringCall = this.connection.prepareCallX("? = CALL SYSIBM.CLOBGETPOSITIONFROMSTRING(?, ?, ?)", 1003, 1007, 2);
            this.clobGetPositionFromStringCall.registerOutParameterX(1, -5);
            this.clobGetPositionFromStringCall.isAutoCommittableStatement_ = false;
        }
        String stringToBeCompared = searchLiteral;
        int numChars = Math.min(searchLiteral.length() - offset, length);
        if (numChars != stringToBeCompared.length()) {
            stringToBeCompared = searchLiteral.substring(offset, offset + numChars);
        }
        this.clobGetPositionFromStringCall.setIntX(2, locator);
        this.clobGetPositionFromStringCall.setStringX(3, stringToBeCompared);
        this.clobGetPositionFromStringCall.setLongX(4, fromPosition);
        try {
            this.clobGetPositionFromStringCall.executeX();
        }
        catch (SqlException sqle) {
            sqle = this.handleInvalidLocator(sqle);
            throw sqle;
        }
        return this.clobGetPositionFromStringCall.getLongX(1);
    }

    long clobGetPositionFromLocator(int locator, int searchLocator, long fromPosition) throws SqlException {
        if (this.clobGetPositionFromLocatorCall == null || !this.clobGetPositionFromLocatorCall.openOnClient_) {
            this.clobGetPositionFromLocatorCall = this.connection.prepareCallX("? = CALL SYSIBM.CLOBGETPOSITIONFROMLOCATOR(?, ?, ?)", 1003, 1007, 2);
            this.clobGetPositionFromLocatorCall.registerOutParameterX(1, -5);
            this.clobGetPositionFromLocatorCall.isAutoCommittableStatement_ = false;
        }
        this.clobGetPositionFromLocatorCall.setIntX(2, locator);
        this.clobGetPositionFromLocatorCall.setIntX(3, searchLocator);
        this.clobGetPositionFromLocatorCall.setLongX(4, fromPosition);
        try {
            this.clobGetPositionFromLocatorCall.executeX();
        }
        catch (SqlException sqle) {
            sqle = this.handleInvalidLocator(sqle);
            throw sqle;
        }
        return this.clobGetPositionFromLocatorCall.getLongX(1);
    }

    long clobGetLength(int sourceLocator) throws SqlException {
        if (this.clobGetLengthCall == null || !this.clobGetLengthCall.openOnClient_) {
            this.clobGetLengthCall = this.connection.prepareCallX("? = CALL SYSIBM.CLOBGETLENGTH(?)", 1003, 1007, 2);
            this.clobGetLengthCall.registerOutParameterX(1, -5);
            this.clobGetLengthCall.isAutoCommittableStatement_ = false;
        }
        this.clobGetLengthCall.setIntX(2, sourceLocator);
        try {
            this.clobGetLengthCall.executeX();
        }
        catch (SqlException sqle) {
            sqle = this.handleInvalidLocator(sqle);
            throw sqle;
        }
        return this.clobGetLengthCall.getLongX(1);
    }

    String clobGetSubString(int sourceLocator, long fromPosition, int forLength) throws SqlException {
        String result;
        if (forLength == 0) {
            return "";
        }
        if (this.clobGetSubStringCall == null || !this.clobGetSubStringCall.openOnClient_) {
            this.clobGetSubStringCall = this.connection.prepareCallX("? = CALL SYSIBM.CLOBGETSUBSTRING(?, ?, ?)", 1003, 1007, 2);
            this.clobGetSubStringCall.registerOutParameterX(1, 12);
            this.clobGetSubStringCall.isAutoCommittableStatement_ = false;
        }
        StringBuffer retVal = null;
        for (int gotSoFar = 0; gotSoFar < forLength; gotSoFar += result.length()) {
            this.clobGetSubStringCall.setIntX(2, sourceLocator);
            this.clobGetSubStringCall.setLongX(3, fromPosition + (long)gotSoFar);
            this.clobGetSubStringCall.setIntX(4, forLength - gotSoFar);
            try {
                this.clobGetSubStringCall.executeX();
            }
            catch (SqlException sqle) {
                sqle = this.handleInvalidLocator(sqle);
                throw sqle;
            }
            result = this.clobGetSubStringCall.getStringX(1);
            if (gotSoFar == 0) {
                if (result.length() == forLength) {
                    return result;
                }
                retVal = new StringBuffer(forLength);
            }
            if (result.length() == 0) break;
            retVal.append(result);
        }
        return retVal.toString();
    }

    void clobSetString(int sourceLocator, long fromPosition, int forLength, String string) throws SqlException {
        int numCharsThisRound;
        if (this.clobSetStringCall == null || !this.clobSetStringCall.openOnClient_) {
            this.clobSetStringCall = this.connection.prepareCallX("CALL SYSIBM.CLOBSETSTRING(?, ?, ?, ?)", 1003, 1007, 2);
            this.clobSetStringCall.isAutoCommittableStatement_ = false;
        }
        String stringToBeSent = string;
        for (int sentSoFar = 0; sentSoFar < forLength; sentSoFar += numCharsThisRound) {
            numCharsThisRound = Math.min(forLength - sentSoFar, 32672);
            if (numCharsThisRound < string.length()) {
                stringToBeSent = string.substring(sentSoFar, sentSoFar + numCharsThisRound);
            }
            this.clobSetStringCall.setIntX(1, sourceLocator);
            this.clobSetStringCall.setLongX(2, fromPosition + (long)sentSoFar);
            this.clobSetStringCall.setIntX(3, numCharsThisRound);
            this.clobSetStringCall.setStringX(4, stringToBeSent);
            try {
                this.clobSetStringCall.executeX();
                continue;
            }
            catch (SqlException sqle) {
                sqle = this.handleInvalidLocator(sqle);
                throw sqle;
            }
        }
    }

    void clobTruncate(int sourceLocator, long length) throws SqlException {
        if (this.clobTruncateCall == null || !this.clobTruncateCall.openOnClient_) {
            this.clobTruncateCall = this.connection.prepareCallX("CALL SYSIBM.CLOBTRUNCATE(?, ?)", 1003, 1007, 2);
            this.clobTruncateCall.isAutoCommittableStatement_ = false;
        }
        this.clobTruncateCall.setIntX(1, sourceLocator);
        this.clobTruncateCall.setLongX(2, length);
        try {
            this.clobTruncateCall.executeX();
        }
        catch (SqlException sqle) {
            sqle = this.handleInvalidLocator(sqle);
            throw sqle;
        }
    }

    private SqlException handleInvalidLocator(SqlException sqle) {
        for (SqlException ex = sqle; ex != null; ex = ex.getNextException()) {
            if (ex.getSQLState().compareTo(ExceptionUtil.getSQLStateFromIdentifier("XJ217.S")) != 0) continue;
            return new SqlException(this.connection.agent_.logWriter_, new ClientMessageId("XJ215.S"), null, (Throwable)sqle);
        }
        return sqle;
    }
}

