/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.BlobLocatorInputStream;
import org.apache.derby.client.am.CallableLocatorProcedures;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.ClobLocatorInputStream;
import org.apache.derby.client.am.ClobLocatorReader;
import org.apache.derby.client.am.ColumnTypeConversionException;
import org.apache.derby.client.am.DateTime;
import org.apache.derby.client.am.Decimal;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.FloatingPoint;
import org.apache.derby.client.am.SignedBinary;
import org.apache.derby.client.am.SqlException;

public abstract class Cursor {
    protected Agent agent_;
    public static final int STRING = 0;
    public static final int VARIABLE_STRING = 2;
    public static final int VARIABLE_SHORT_STRING = 1;
    public static final int NULL_TERMINATED_STRING = 3;
    public static final int BYTES = 4;
    public static final int VARIABLE_BYTES = 5;
    public static final int VARIABLE_SHORT_BYTES = 6;
    public static final int NULL_TERMINATED_BYTES = 7;
    public static final int SBCS_CLOB = 8;
    public static final int MBCS_CLOB = 9;
    public static final int DBCS_CLOB = 10;
    public byte[] dataBuffer_;
    public ByteArrayOutputStream dataBufferStream_;
    public int position_;
    public int lastValidBytePosition_;
    public boolean hasLobs_;
    protected int currentRowPosition_;
    private int nextRowPosition_;
    protected int[] columnDataPosition_;
    protected int[] columnDataComputedLength_;
    private boolean allRowsReceivedFromServer_;
    int rowsRead_;
    int maxFieldSize_ = 0;
    protected ArrayList columnDataPositionCache_ = new ArrayList();
    protected ArrayList columnDataLengthCache_ = new ArrayList();
    protected ArrayList columnDataIsNullCache_ = new ArrayList();
    public ArrayList isUpdateDeleteHoleCache_ = new ArrayList();
    public boolean isUpdateDeleteHole_;
    private boolean isRowUpdated_;
    public static final Boolean ROW_IS_NULL = new Boolean(true);
    public static final Boolean ROW_IS_NOT_NULL = new Boolean(false);
    Calendar recyclableCalendar_ = null;
    public int[] jdbcTypes_;
    public int columns_;
    public boolean[] nullable_;
    public String[] charsetName_;
    public boolean[] isNull_;
    public int[] fdocaLength_;
    public int[] ccsid_;
    char[] charBuffer_;

    public Cursor(Agent agent) {
        this.agent_ = agent;
        this.isRowUpdated_ = false;
        this.dataBufferStream_ = new ByteArrayOutputStream();
    }

    public Cursor(Agent agent, byte[] dataBuffer) {
        this(agent);
        this.dataBuffer_ = dataBuffer;
        this.setAllRowsReceivedFromServer(false);
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.columnDataPosition_ = new int[numberOfColumns];
        this.columnDataComputedLength_ = new int[numberOfColumns];
        this.columns_ = numberOfColumns;
        this.nullable_ = new boolean[numberOfColumns];
        this.charsetName_ = new String[numberOfColumns];
        this.ccsid_ = new int[numberOfColumns];
        this.isNull_ = new boolean[numberOfColumns];
        this.jdbcTypes_ = new int[numberOfColumns];
    }

    protected boolean stepNext(boolean allowServerFetch) throws SqlException {
        boolean rowPositionIsValid = true;
        this.clearLobData_();
        this.makeNextRowPositionCurrent();
        this.isUpdateDeleteHole_ = false;
        this.isRowUpdated_ = false;
        while (!this.dataBufferHasUnprocessedData()) {
            if (this.allRowsReceivedFromServer_) {
                return false;
            }
            this.getMoreData_();
        }
        rowPositionIsValid = this.calculateColumnOffsetsForRow_(0, allowServerFetch);
        this.markNextRowPosition();
        return rowPositionIsValid;
    }

    public boolean next() throws SqlException {
        return this.stepNext(true);
    }

    public void setAllRowsReceivedFromServer(boolean b) {
        this.allRowsReceivedFromServer_ = b;
    }

    public final boolean allRowsReceivedFromServer() {
        return this.allRowsReceivedFromServer_;
    }

    public final boolean currentRowPositionIsEqualToNextRowPosition() {
        return this.currentRowPosition_ == this.nextRowPosition_;
    }

    public final void resetDataBuffer() {
        this.position_ = 0;
        this.lastValidBytePosition_ = 0;
        this.currentRowPosition_ = 0;
        this.nextRowPosition_ = 0;
        this.setAllRowsReceivedFromServer(false);
        this.dataBufferStream_.reset();
    }

    public final boolean dataBufferHasUnprocessedData() {
        return this.lastValidBytePosition_ - this.position_ > 0;
    }

    protected abstract boolean calculateColumnOffsetsForRow_(int var1, boolean var2) throws SqlException, DisconnectException;

    protected abstract void clearLobData_();

    protected abstract void getMoreData_() throws SqlException;

    public final void setBuffer(byte[] dataBuffer) {
        this.dataBuffer_ = dataBuffer;
    }

    public final void setIsUpdataDeleteHole(int row, boolean isRowNull) {
        Boolean nullIndicator;
        this.isUpdateDeleteHole_ = isRowNull;
        Boolean bl = nullIndicator = this.isUpdateDeleteHole_ ? ROW_IS_NULL : ROW_IS_NOT_NULL;
        if (this.isUpdateDeleteHoleCache_.size() == row) {
            this.isUpdateDeleteHoleCache_.add(nullIndicator);
        } else {
            this.isUpdateDeleteHoleCache_.set(row, nullIndicator);
        }
    }

    public final void setIsRowUpdated(boolean isRowUpdated) {
        this.isRowUpdated_ = isRowUpdated;
    }

    public final boolean getIsRowUpdated() {
        return this.isRowUpdated_;
    }

    public final boolean getIsUpdateDeleteHole() {
        return this.isUpdateDeleteHole_;
    }

    final int getPosition() {
        return this.position_;
    }

    final void setPosition(int newPosition) {
        this.position_ = newPosition;
    }

    public final void markCurrentRowPosition() {
        this.currentRowPosition_ = this.position_;
    }

    public final void markNextRowPosition() {
        this.nextRowPosition_ = this.position_;
    }

    public final void makeNextRowPositionCurrent() {
        this.currentRowPosition_ = this.nextRowPosition_;
    }

    final void repositionCursorToCurrentRow() {
        this.position_ = this.currentRowPosition_;
    }

    final void repositionCursorToNextRow() {
        this.position_ = this.nextRowPosition_;
    }

    public final byte[] getDataBuffer() {
        return this.dataBuffer_;
    }

    public final int getDataBufferLength() {
        return this.dataBuffer_.length;
    }

    public final int getLastValidBytePosition() {
        return this.lastValidBytePosition_;
    }

    public final void incrementRowsReadEvent() {
        ++this.rowsRead_;
    }

    private final short get_SMALLINT(int column) {
        return SignedBinary.getShort(this.dataBuffer_, this.columnDataPosition_[column - 1]);
    }

    protected final int get_INTEGER(int column) {
        return SignedBinary.getInt(this.dataBuffer_, this.columnDataPosition_[column - 1]);
    }

    private final long get_BIGINT(int column) {
        return SignedBinary.getLong(this.dataBuffer_, this.columnDataPosition_[column - 1]);
    }

    private final float get_FLOAT(int column) {
        return FloatingPoint.getFloat(this.dataBuffer_, this.columnDataPosition_[column - 1]);
    }

    private final double get_DOUBLE(int column) {
        return FloatingPoint.getDouble(this.dataBuffer_, this.columnDataPosition_[column - 1]);
    }

    private final BigDecimal get_DECIMAL(int column) throws SqlException {
        try {
            return Decimal.getBigDecimal(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getColumnPrecision(column - 1), this.getColumnScale(column - 1));
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"DECIMAL", (Object)"java.math.BigDecimal", (Throwable)e);
        }
    }

    private final double getDoubleFromDECIMAL(int column) throws SqlException {
        try {
            return Decimal.getDouble(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getColumnPrecision(column - 1), this.getColumnScale(column - 1));
        }
        catch (IllegalArgumentException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003"), (Object)"double", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"DECIMAL", (Object)"double", (Throwable)e);
        }
    }

    private final long getLongFromDECIMAL(int column) throws SqlException {
        try {
            return Decimal.getLong(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getColumnPrecision(column - 1), this.getColumnScale(column - 1));
        }
        catch (IllegalArgumentException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003"), (Object)"long", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"DECIMAL", (Object)"long", (Throwable)e);
        }
    }

    private final String getVARCHAR(int column) throws SqlException {
        String tempString = null;
        try {
            if (this.ccsid_[column - 1] == 1200) {
                return this.getStringWithoutConvert(this.columnDataPosition_[column - 1] + 2, this.columnDataComputedLength_[column - 1] - 2);
            }
            if (this.charsetName_[column - 1] == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.2"));
            }
            tempString = new String(this.dataBuffer_, this.columnDataPosition_[column - 1] + 2, this.columnDataComputedLength_[column - 1] - 2, this.charsetName_[column - 1]);
            return this.maxFieldSize_ == 0 ? tempString : tempString.substring(0, Math.min(this.maxFieldSize_, tempString.length()));
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"VARCHAR", (Object)"String", (Throwable)e);
        }
    }

    private final String getCHAR(int column) throws SqlException {
        String tempString = null;
        if (this.ccsid_[column - 1] == 1200) {
            return this.getStringWithoutConvert(this.columnDataPosition_[column - 1], this.columnDataComputedLength_[column - 1]);
        }
        try {
            if (this.charsetName_[column - 1] == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.2"));
            }
            tempString = new String(this.dataBuffer_, this.columnDataPosition_[column - 1], this.columnDataComputedLength_[column - 1], this.charsetName_[column - 1]);
            return this.maxFieldSize_ == 0 ? tempString : tempString.substring(0, Math.min(this.maxFieldSize_, tempString.length()));
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"CHAR", (Object)"String", (Throwable)e);
        }
    }

    private final Date getDATE(int column) throws SqlException {
        try {
            return DateTime.dateBytesToDate(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getRecyclableCalendar(), this.charsetName_[column - 1]);
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"DATE", (Object)"java.sql.Date", (Throwable)e);
        }
    }

    private final Time getTIME(int column) throws SqlException {
        try {
            return DateTime.timeBytesToTime(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getRecyclableCalendar(), this.charsetName_[column - 1]);
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"TIME", (Object)"java.sql.Time", (Throwable)e);
        }
    }

    private final Timestamp getTIMESTAMP(int column) throws SqlException {
        try {
            return DateTime.timestampBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getRecyclableCalendar(), this.charsetName_[column - 1]);
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"TIMESTAMP", (Object)"java.sql.Timestamp", (Throwable)e);
        }
    }

    private final Timestamp getTimestampFromDATE(int column) throws SqlException {
        try {
            return DateTime.dateBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getRecyclableCalendar(), this.charsetName_[column - 1]);
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"DATE", (Object)"java.sql.Timestamp", (Throwable)e);
        }
    }

    private final Timestamp getTimestampFromTIME(int column) throws SqlException {
        try {
            return DateTime.timeBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getRecyclableCalendar(), this.charsetName_[column - 1]);
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"TIME", (Object)"java.sql.Timestamp", (Throwable)e);
        }
    }

    private final Date getDateFromTIMESTAMP(int column) throws SqlException {
        try {
            return DateTime.timestampBytesToDate(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getRecyclableCalendar(), this.charsetName_[column - 1]);
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"TIMESTAMP", (Object)"java.sql.Date", (Throwable)e);
        }
    }

    private final Time getTimeFromTIMESTAMP(int column) throws SqlException {
        try {
            return DateTime.timestampBytesToTime(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getRecyclableCalendar(), this.charsetName_[column - 1]);
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"TIMESTAMP", (Object)"java.sql.Time", (Throwable)e);
        }
    }

    private final String getStringFromDATE(int column) throws SqlException {
        return this.getDATE(column).toString();
    }

    private final String getStringFromTIME(int column) throws SqlException {
        return this.getTIME(column).toString();
    }

    private final String getStringFromTIMESTAMP(int column) throws SqlException {
        return this.getTIMESTAMP(column).toString();
    }

    private final byte[] get_CHAR_FOR_BIT_DATA(int column) throws SqlException {
        int columnLength = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[column - 1] : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[column - 1]);
        byte[] bytes = new byte[columnLength];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[column - 1], bytes, 0, columnLength);
        return bytes;
    }

    private final byte[] get_VARCHAR_FOR_BIT_DATA(int column) throws SqlException {
        int columnLength = 0;
        columnLength = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[column - 1] - 2 : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[column - 1] - 2);
        byte[] bytes = new byte[columnLength];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[column - 1] + 2, bytes, 0, bytes.length);
        return bytes;
    }

    private Calendar getRecyclableCalendar() {
        if (this.recyclableCalendar_ == null) {
            this.recyclableCalendar_ = new GregorianCalendar();
        }
        return this.recyclableCalendar_;
    }

    CallableLocatorProcedures getLocatorProcedures() {
        return this.agent_.connection_.locatorProcedureCall();
    }

    protected abstract int locator(int var1);

    public abstract Blob getBlobColumn_(int var1, Agent var2, boolean var3) throws SqlException;

    public abstract Clob getClobColumn_(int var1, Agent var2, boolean var3) throws SqlException;

    public abstract byte[] getClobBytes_(int var1, int[] var2) throws SqlException;

    final boolean getBoolean(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 5: {
                return this.agent_.crossConverters_.getBooleanFromShort(this.get_SMALLINT(column));
            }
            case 4: {
                return this.agent_.crossConverters_.getBooleanFromInt(this.get_INTEGER(column));
            }
            case -5: {
                return this.agent_.crossConverters_.getBooleanFromLong(this.get_BIGINT(column));
            }
            case 7: {
                return this.agent_.crossConverters_.getBooleanFromFloat(this.get_FLOAT(column));
            }
            case 8: {
                return this.agent_.crossConverters_.getBooleanFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return this.agent_.crossConverters_.getBooleanFromLong(this.getLongFromDECIMAL(column));
            }
            case 1: {
                return this.agent_.crossConverters_.getBooleanFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getBooleanFromString(this.getVARCHAR(column));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "boolean");
    }

    final byte getByte(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 5: {
                return this.agent_.crossConverters_.getByteFromShort(this.get_SMALLINT(column));
            }
            case 4: {
                return this.agent_.crossConverters_.getByteFromInt(this.get_INTEGER(column));
            }
            case -5: {
                return this.agent_.crossConverters_.getByteFromLong(this.get_BIGINT(column));
            }
            case 7: {
                return this.agent_.crossConverters_.getByteFromFloat(this.get_FLOAT(column));
            }
            case 8: {
                return this.agent_.crossConverters_.getByteFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return this.agent_.crossConverters_.getByteFromLong(this.getLongFromDECIMAL(column));
            }
            case 1: {
                return this.agent_.crossConverters_.getByteFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getByteFromString(this.getVARCHAR(column));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "byte");
    }

    final short getShort(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.agent_.crossConverters_.getShortFromInt(this.get_INTEGER(column));
            }
            case -5: {
                return this.agent_.crossConverters_.getShortFromLong(this.get_BIGINT(column));
            }
            case 7: {
                return this.agent_.crossConverters_.getShortFromFloat(this.get_FLOAT(column));
            }
            case 8: {
                return this.agent_.crossConverters_.getShortFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return this.agent_.crossConverters_.getShortFromLong(this.getLongFromDECIMAL(column));
            }
            case 1: {
                return this.agent_.crossConverters_.getShortFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getShortFromString(this.getVARCHAR(column));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "short");
    }

    final int getInt(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.get_INTEGER(column);
            }
            case -5: {
                return this.agent_.crossConverters_.getIntFromLong(this.get_BIGINT(column));
            }
            case 7: {
                return this.agent_.crossConverters_.getIntFromFloat(this.get_FLOAT(column));
            }
            case 8: {
                return this.agent_.crossConverters_.getIntFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return this.agent_.crossConverters_.getIntFromLong(this.getLongFromDECIMAL(column));
            }
            case 1: {
                return this.agent_.crossConverters_.getIntFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getIntFromString(this.getVARCHAR(column));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "int");
    }

    final long getLong(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.get_INTEGER(column);
            }
            case -5: {
                return this.get_BIGINT(column);
            }
            case 7: {
                return this.agent_.crossConverters_.getLongFromFloat(this.get_FLOAT(column));
            }
            case 8: {
                return this.agent_.crossConverters_.getLongFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return this.getLongFromDECIMAL(column);
            }
            case 1: {
                return this.agent_.crossConverters_.getLongFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getLongFromString(this.getVARCHAR(column));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "long");
    }

    final float getFloat(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 7: {
                return this.get_FLOAT(column);
            }
            case 8: {
                return this.agent_.crossConverters_.getFloatFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return this.agent_.crossConverters_.getFloatFromDouble(this.getDoubleFromDECIMAL(column));
            }
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.get_INTEGER(column);
            }
            case -5: {
                return this.get_BIGINT(column);
            }
            case 1: {
                return this.agent_.crossConverters_.getFloatFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getFloatFromString(this.getVARCHAR(column));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "float");
    }

    final double getDouble(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 7: {
                double d = this.get_FLOAT(column);
                return d;
            }
            case 8: {
                return this.get_DOUBLE(column);
            }
            case 3: {
                return this.getDoubleFromDECIMAL(column);
            }
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.get_INTEGER(column);
            }
            case -5: {
                return this.get_BIGINT(column);
            }
            case 1: {
                return this.agent_.crossConverters_.getDoubleFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getDoubleFromString(this.getVARCHAR(column));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "double");
    }

    final BigDecimal getBigDecimal(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 3: {
                return this.get_DECIMAL(column);
            }
            case 7: {
                float f = this.get_FLOAT(column);
                return new BigDecimal(String.valueOf(f));
            }
            case 8: {
                return new BigDecimal(String.valueOf(this.get_DOUBLE(column)));
            }
            case 5: {
                return BigDecimal.valueOf(this.get_SMALLINT(column));
            }
            case 4: {
                return BigDecimal.valueOf(this.get_INTEGER(column));
            }
            case -5: {
                return BigDecimal.valueOf(this.get_BIGINT(column));
            }
            case 1: {
                return this.agent_.crossConverters_.getBigDecimalFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getBigDecimalFromString(this.getVARCHAR(column));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "java.math.BigDecimal");
    }

    final Date getDate(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 91: {
                return this.getDATE(column);
            }
            case 93: {
                return this.getDateFromTIMESTAMP(column);
            }
            case 1: {
                return this.agent_.crossConverters_.getDateFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getDateFromString(this.getVARCHAR(column));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "java.sql.Date");
    }

    final Time getTime(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 92: {
                return this.getTIME(column);
            }
            case 93: {
                return this.getTimeFromTIMESTAMP(column);
            }
            case 1: {
                return this.agent_.crossConverters_.getTimeFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getTimeFromString(this.getVARCHAR(column));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "java.sql.Time");
    }

    final Timestamp getTimestamp(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 93: {
                return this.getTIMESTAMP(column);
            }
            case 91: {
                return this.getTimestampFromDATE(column);
            }
            case 92: {
                return this.getTimestampFromTIME(column);
            }
            case 1: {
                return this.agent_.crossConverters_.getTimestampFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getTimestampFromString(this.getVARCHAR(column));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "java.sql.Timestamp");
    }

    final String getString(int column) throws SqlException {
        try {
            String tempString = null;
            switch (this.jdbcTypes_[column - 1]) {
                case 1: {
                    return this.getCHAR(column);
                }
                case -1: 
                case 12: {
                    return this.getVARCHAR(column);
                }
                case 5: {
                    return String.valueOf(this.get_SMALLINT(column));
                }
                case 4: {
                    return String.valueOf(this.get_INTEGER(column));
                }
                case -5: {
                    return String.valueOf(this.get_BIGINT(column));
                }
                case 7: {
                    return String.valueOf(this.get_FLOAT(column));
                }
                case 8: {
                    return String.valueOf(this.get_DOUBLE(column));
                }
                case 3: {
                    return String.valueOf(this.get_DECIMAL(column));
                }
                case 91: {
                    return this.getStringFromDATE(column);
                }
                case 92: {
                    return this.getStringFromTIME(column);
                }
                case 93: {
                    return this.getStringFromTIMESTAMP(column);
                }
                case -2: {
                    tempString = this.agent_.crossConverters_.getStringFromBytes(this.get_CHAR_FOR_BIT_DATA(column));
                    return this.maxFieldSize_ == 0 ? tempString : tempString.substring(0, Math.min(this.maxFieldSize_, tempString.length()));
                }
                case -4: 
                case -3: {
                    tempString = this.agent_.crossConverters_.getStringFromBytes(this.get_VARCHAR_FOR_BIT_DATA(column));
                    return this.maxFieldSize_ == 0 ? tempString : tempString.substring(0, Math.min(this.maxFieldSize_, tempString.length()));
                }
                case 2004: {
                    Blob b = this.getBlobColumn_(column, this.agent_, false);
                    tempString = this.agent_.crossConverters_.getStringFromBytes(b.getBytes(1L, (int)b.length()));
                    return tempString;
                }
                case 2005: {
                    Clob c = this.getClobColumn_(column, this.agent_, false);
                    tempString = c.getSubString(1L, (int)c.length());
                    return tempString;
                }
            }
            throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "String");
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
    }

    final byte[] getBytes(int column) throws SqlException {
        try {
            switch (this.jdbcTypes_[column - 1]) {
                case -2: {
                    return this.get_CHAR_FOR_BIT_DATA(column);
                }
                case -4: 
                case -3: {
                    return this.get_VARCHAR_FOR_BIT_DATA(column);
                }
                case 2004: {
                    Blob b = this.getBlobColumn_(column, this.agent_, false);
                    byte[] bytes = b.getBytes(1L, (int)b.length());
                    return bytes;
                }
            }
            throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "byte[]");
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
    }

    public final InputStream getBinaryStream(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case -2: {
                return new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(column));
            }
            case -4: 
            case -3: {
                return new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(column));
            }
            case 2004: {
                Blob b = this.getBlobColumn_(column, this.agent_, false);
                if (b.isLocator()) {
                    BlobLocatorInputStream is = new BlobLocatorInputStream(this.agent_.connection_, b);
                    return new BufferedInputStream(is);
                }
                return b.getBinaryStreamX();
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "java.io.InputStream");
    }

    public final InputStream getAsciiStream(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 2005: {
                Clob c = this.getClobColumn_(column, this.agent_, false);
                if (c.isLocator()) {
                    ClobLocatorInputStream is = new ClobLocatorInputStream(this.agent_.connection_, c);
                    return new BufferedInputStream(is);
                }
                return c.getAsciiStreamX();
            }
            case 1: {
                try {
                    return new ByteArrayInputStream(this.getCHAR(column).getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"CHAR", (Object)"java.io.InputStream", (Throwable)e);
                }
            }
            case -1: 
            case 12: {
                try {
                    return new ByteArrayInputStream(this.getVARCHAR(column).getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"VARCHAR/LONGVARCHAR", (Object)"java.io.InputStream", (Throwable)e);
                }
            }
            case -2: {
                return new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(column));
            }
            case -4: 
            case -3: {
                return new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(column));
            }
            case 2004: {
                return this.getBinaryStream(column);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "java.io.InputStream");
    }

    public final InputStream getUnicodeStream(int column) throws SqlException {
        try {
            switch (this.jdbcTypes_[column - 1]) {
                case 2005: {
                    Clob c = this.getClobColumn_(column, this.agent_, false);
                    String s = c.getSubString(1L, (int)c.length());
                    try {
                        return new ByteArrayInputStream(s.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"CLOB", (Object)"UnicodeStream", (Throwable)e);
                    }
                }
                case 1: {
                    try {
                        return new ByteArrayInputStream(this.getCHAR(column).getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"CHAR", (Object)"UnicodeStream", (Throwable)e);
                    }
                }
                case -1: 
                case 12: {
                    try {
                        return new ByteArrayInputStream(this.getVARCHAR(column).getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"VARCHAR/LONGVARCHAR", (Object)"UnicodeStream", (Throwable)e);
                    }
                }
                case -2: {
                    return new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(column));
                }
                case -4: 
                case -3: {
                    return new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(column));
                }
                case 2004: {
                    return this.getBinaryStream(column);
                }
            }
            throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "UnicodeStream");
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
    }

    public final Reader getCharacterStream(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 2005: {
                Clob c = this.getClobColumn_(column, this.agent_, false);
                if (c.isLocator()) {
                    ClobLocatorReader reader = new ClobLocatorReader(this.agent_.connection_, c);
                    return new BufferedReader(reader);
                }
                return c.getCharacterStreamX();
            }
            case 1: {
                return new StringReader(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return new StringReader(this.getVARCHAR(column));
            }
            case -2: {
                try {
                    return new InputStreamReader((InputStream)new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(column)), "UTF-16BE");
                }
                catch (UnsupportedEncodingException e) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"BINARY", (Object)"java.io.Reader", (Throwable)e);
                }
            }
            case -4: 
            case -3: {
                try {
                    return new InputStreamReader((InputStream)new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(column)), "UTF-16BE");
                }
                catch (UnsupportedEncodingException e) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"VARBINARY/LONGVARBINARY", (Object)"java.io.Reader", (Throwable)e);
                }
            }
            case 2004: {
                try {
                    return new InputStreamReader(this.getBinaryStream(column), "UTF-16BE");
                }
                catch (UnsupportedEncodingException e) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"BLOB", (Object)"java.io.Reader", (Throwable)e);
                }
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "java.io.Reader");
    }

    public final java.sql.Blob getBlob(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 2004: {
                return this.getBlobColumn_(column, this.agent_, true);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "java.sql.Blob");
    }

    public final java.sql.Clob getClob(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 2005: {
                return this.getClobColumn_(column, this.agent_, true);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "java.sql.Clob");
    }

    public final Array getArray(int column) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S"), "getArray(int)");
    }

    public final Ref getRef(int column) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S"), "getRef(int)");
    }

    public final Object getObject(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 5: {
                return new Integer(this.get_SMALLINT(column));
            }
            case 4: {
                return new Integer(this.get_INTEGER(column));
            }
            case -5: {
                return new Long(this.get_BIGINT(column));
            }
            case 7: {
                return new Float(this.get_FLOAT(column));
            }
            case 8: {
                return new Double(this.get_DOUBLE(column));
            }
            case 3: {
                return this.get_DECIMAL(column);
            }
            case 91: {
                return this.getDATE(column);
            }
            case 92: {
                return this.getTIME(column);
            }
            case 93: {
                return this.getTIMESTAMP(column);
            }
            case 1: {
                return this.getCHAR(column);
            }
            case -1: 
            case 12: {
                return this.getVARCHAR(column);
            }
            case -2: {
                return this.get_CHAR_FOR_BIT_DATA(column);
            }
            case -4: 
            case -3: {
                return this.get_VARCHAR_FOR_BIT_DATA(column);
            }
            case 2004: {
                return this.getBlobColumn_(column, this.agent_, true);
            }
            case 2005: {
                return this.getClobColumn_(column, this.agent_, true);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, "java.sql.Types " + this.jdbcTypes_[column - 1], "Object");
    }

    public final void allocateCharBuffer() {
        int maxCharLength = 0;
        block3: for (int i = 0; i < this.columns_; ++i) {
            switch (this.jdbcTypes_[i]) {
                case -1: 
                case 1: 
                case 12: {
                    if (this.fdocaLength_[i] <= maxCharLength) continue block3;
                    maxCharLength = this.fdocaLength_[i];
                }
            }
        }
        this.charBuffer_ = new char[maxCharLength];
    }

    private final String getStringWithoutConvert(int position, int actualLength) throws SqlException {
        int end = position + actualLength;
        int charCount = 0;
        for (int start = position; start < end; start += 2) {
            this.charBuffer_[charCount++] = (char)((this.dataBuffer_[start] & 0xFF) << 8 | this.dataBuffer_[start + 1] & 0xFF);
        }
        return new String(this.charBuffer_, 0, charCount);
    }

    public void nullDataForGC() {
        this.dataBuffer_ = null;
        this.dataBufferStream_ = null;
        this.columnDataPosition_ = null;
        this.columnDataComputedLength_ = null;
        this.columnDataPositionCache_ = null;
        this.columnDataLengthCache_ = null;
        this.columnDataIsNullCache_ = null;
        this.jdbcTypes_ = null;
        this.nullable_ = null;
        this.charsetName_ = null;
        this.ccsid_ = null;
        this.isUpdateDeleteHoleCache_ = null;
        this.isNull_ = null;
        this.fdocaLength_ = null;
        this.charBuffer_ = null;
    }

    private final int getColumnPrecision(int column) {
        return this.fdocaLength_[column] >> 8 & 0xFF;
    }

    private final int getColumnScale(int column) {
        return this.fdocaLength_[column] & 0xFF;
    }

    final byte[] getBytesFromVARCHAR(int column) throws SqlException {
        byte[] bytes = new byte[this.columnDataComputedLength_[column - 1] - 2];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[column - 1] + 2, bytes, 0, bytes.length);
        return bytes;
    }
}

