/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.util.Arrays;
import org.apache.derby.client.am.CallableLocatorProcedures;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.SqlException;

class LOBStateTracker {
    public static final LOBStateTracker NO_OP_TRACKER = new LOBStateTracker(new int[0], new boolean[0], false);
    private final int[] columns;
    private final boolean[] isBlob;
    private final boolean[] published;
    private final boolean doRelease;
    private final int[] lastLocatorSeen;

    LOBStateTracker(int[] lobIndexes, boolean[] isBlob, boolean doRelease) {
        this.columns = lobIndexes;
        this.isBlob = isBlob;
        this.published = new boolean[this.columns.length];
        this.doRelease = doRelease;
        this.lastLocatorSeen = new int[this.columns.length];
    }

    void checkCurrentRow(Cursor cursor) throws SqlException {
        if (this.doRelease) {
            CallableLocatorProcedures procs = cursor.getLocatorProcedures();
            for (int i = 0; i < this.columns.length; ++i) {
                if (this.published[i] || cursor.isNull_[this.columns[i] - 1]) continue;
                int locator = cursor.locator(this.columns[i]);
                if (locator == this.lastLocatorSeen[i]) {
                    return;
                }
                if (locator == -1) {
                    return;
                }
                this.lastLocatorSeen[i] = locator;
                if (this.isBlob[i]) {
                    procs.blobReleaseLocator(locator);
                    continue;
                }
                procs.clobReleaseLocator(locator);
            }
            Arrays.fill(this.published, false);
        }
    }

    void discardState() {
        if (this.doRelease) {
            Arrays.fill(this.published, true);
        }
    }

    void markAsPublished(int index) {
        if (this.doRelease) {
            int internalIndex = Arrays.binarySearch(this.columns, index);
            this.published[internalIndex] = true;
        }
    }
}

