/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.Util;

class UpdatableBlobStream
extends InputStream {
    private boolean materialized;
    private InputStream stream;
    private long pos;
    private final EmbedBlob blob;
    private final long maxPos;

    UpdatableBlobStream(EmbedBlob blob, InputStream is) throws IOException {
        this(blob, is, 0L, Long.MAX_VALUE);
    }

    UpdatableBlobStream(EmbedBlob blob, InputStream is, long pos, long len) throws IOException {
        this.blob = blob;
        this.stream = is;
        this.maxPos = pos + len;
        if (pos > 0L) {
            this.skip(pos);
        }
    }

    private void updateIfRequired() throws IOException {
        if (this.materialized) {
            return;
        }
        if (this.blob.isMaterialized()) {
            this.materialized = true;
            try {
                this.stream = this.blob.getBinaryStream();
            }
            catch (SQLException ex) {
                throw Util.newIOException(ex);
            }
            InputStreamUtil.skipFully(this.stream, this.pos);
        }
    }

    public int read() throws IOException {
        this.updateIfRequired();
        if (this.pos >= this.maxPos) {
            return -1;
        }
        int ret = this.stream.read();
        if (ret >= 0) {
            ++this.pos;
        }
        return ret;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.updateIfRequired();
        long remaining = this.maxPos - this.pos;
        if (remaining == 0L && len > 0) {
            return -1;
        }
        int actualLength = (int)Math.min((long)len, remaining);
        int retValue = this.stream.read(b, off, actualLength);
        if (retValue > 0) {
            this.pos += (long)retValue;
        }
        return retValue;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        this.updateIfRequired();
        long retValue = this.stream.skip(n);
        if (retValue > 0L) {
            this.pos += retValue;
        }
        return retValue;
    }
}

