/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;

public class SpecificAuthenticationServiceImpl
extends AuthenticationServiceBase {
    private String specificAuthenticationScheme;

    public boolean canSupport(Properties properties) {
        if (!this.requireAuthentication(properties)) {
            return false;
        }
        this.specificAuthenticationScheme = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return this.specificAuthenticationScheme != null && this.specificAuthenticationScheme.length() != 0 && !StringUtil.SQLEqualsIgnoreCase(this.specificAuthenticationScheme, "BUILTIN") && !this.specificAuthenticationScheme.equalsIgnoreCase("LDAP");
    }

    public void boot(boolean create, Properties properties) throws StandardException {
        ReflectiveOperationException t;
        super.boot(create, properties);
        try {
            Class<?> sasClass = Class.forName(this.specificAuthenticationScheme);
            if (!UserAuthenticator.class.isAssignableFrom(sasClass)) {
                throw StandardException.newException("XBM0L.D", (Object)this.specificAuthenticationScheme, (Object)"org.apache.derby.authentication.UserAuthenticator");
            }
            UserAuthenticator aScheme = (UserAuthenticator)sasClass.newInstance();
            this.setAuthenticationService(aScheme);
            return;
        }
        catch (ClassNotFoundException cnfe) {
            t = cnfe;
        }
        catch (InstantiationException ie) {
            t = ie;
        }
        catch (IllegalAccessException iae) {
            t = iae;
        }
        throw StandardException.newException("XBM0M.D", t, (Object)this.specificAuthenticationScheme);
    }
}

