/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import org.apache.derby.vti.VTIMetaDataTemplate;

class ImportResultSetMetaData
extends VTIMetaDataTemplate {
    private final int numberOfColumns;
    private final String[] columnNames;
    private final int[] columnWidths;
    private final int[] tableColumnTypes;

    public ImportResultSetMetaData(int numberOfColumns, String[] columnNames, int[] columnWidths, int[] tableColumnTypes) {
        this.numberOfColumns = numberOfColumns;
        this.columnNames = columnNames;
        this.columnWidths = columnWidths;
        this.tableColumnTypes = tableColumnTypes;
    }

    public int getColumnCount() {
        return this.numberOfColumns;
    }

    public String getColumnName(int column) {
        return this.columnNames[column - 1];
    }

    public int getColumnType(int column) {
        int colType;
        switch (this.tableColumnTypes[column - 1]) {
            case 2004: {
                colType = 2004;
                break;
            }
            case 2005: {
                colType = 2005;
                break;
            }
            case -4: {
                colType = -4;
                break;
            }
            case -3: {
                colType = -3;
                break;
            }
            case -2: {
                colType = -2;
                break;
            }
            default: {
                colType = 12;
            }
        }
        return colType;
    }

    public int isNullable(int column) {
        return 2;
    }

    public int getColumnDisplaySize(int column) {
        if (this.columnWidths == null) {
            return 32672;
        }
        return this.columnWidths[column - 1];
    }
}

