/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;

public final class GenericColumnDescriptor
implements ResultColumnDescriptor,
Formatable {
    private String name;
    private String schemaName;
    private String tableName;
    private int columnPos;
    private DataTypeDescriptor type;
    private boolean isAutoincrement;
    private boolean updatableByCursor;
    private boolean hasGenerationClause;

    public GenericColumnDescriptor() {
    }

    public GenericColumnDescriptor(String name, DataTypeDescriptor type) {
        this.name = name;
        this.type = type;
    }

    public GenericColumnDescriptor(ResultColumnDescriptor rcd) {
        this.name = rcd.getName();
        this.tableName = rcd.getSourceTableName();
        this.schemaName = rcd.getSourceSchemaName();
        this.columnPos = rcd.getColumnPosition();
        this.type = rcd.getType();
        this.isAutoincrement = rcd.isAutoincrement();
        this.updatableByCursor = rcd.updatableByCursor();
        this.hasGenerationClause = rcd.hasGenerationClause();
    }

    public DataTypeDescriptor getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceSchemaName() {
        return this.schemaName;
    }

    public String getSourceTableName() {
        return this.tableName;
    }

    public int getColumnPosition() {
        return this.columnPos;
    }

    public boolean isAutoincrement() {
        return this.isAutoincrement;
    }

    public boolean updatableByCursor() {
        return this.updatableByCursor;
    }

    public boolean hasGenerationClause() {
        return this.hasGenerationClause;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        FormatableHashtable fh = new FormatableHashtable();
        fh.put("name", this.name);
        fh.put("tableName", this.tableName);
        fh.put("schemaName", this.schemaName);
        fh.putInt("columnPos", this.columnPos);
        fh.put("type", this.type);
        fh.putBoolean("isAutoincrement", this.isAutoincrement);
        fh.putBoolean("updatableByCursor", this.updatableByCursor);
        out.writeObject(fh);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        FormatableHashtable fh = (FormatableHashtable)in.readObject();
        this.name = (String)fh.get("name");
        this.tableName = (String)fh.get("tableName");
        this.schemaName = (String)fh.get("schemaName");
        this.columnPos = fh.getInt("columnPos");
        this.type = (DataTypeDescriptor)fh.get("type");
        this.isAutoincrement = fh.getBoolean("isAutoincrement");
        this.updatableByCursor = fh.getBoolean("updatableByCursor");
    }

    public int getTypeFormatId() {
        return 383;
    }

    public String toString() {
        return "GenericColumnDescriptor\n\tname: " + this.name + "\n\tTable: " + this.schemaName + "." + this.tableName + "\n\tcolumnPos: " + this.columnPos + "\n\tType: " + this.type;
    }
}

