/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CreateViewNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.LikeEscapeOperatorNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

public class FromBaseTable
extends FromTable {
    static final int UNSET = -1;
    TableName tableName;
    TableDescriptor tableDescriptor;
    ConglomerateDescriptor baseConglomerateDescriptor;
    ConglomerateDescriptor[] conglomDescs;
    int updateOrDelete;
    int bulkFetch = -1;
    boolean bulkFetchTurnedOff;
    boolean multiProbing = false;
    private double singleScanRowCount;
    private FormatableBitSet referencedCols;
    private ResultColumnList templateColumns;
    private String[] columnNames;
    private boolean specialMaxScan;
    private boolean distinctScan;
    private boolean raDependentScan;
    private String raParentResultSetId;
    private long fkIndexConglomId;
    private int[] fkColArray;
    PredicateList baseTableRestrictionList;
    PredicateList nonBaseTableRestrictionList;
    PredicateList restrictionList;
    PredicateList storeRestrictionList;
    PredicateList nonStoreRestrictionList;
    PredicateList requalificationRestrictionList;
    public static final int UPDATE = 1;
    public static final int DELETE = 2;
    private boolean existsBaseTable;
    private boolean isNotExists;
    private JBitSet dependencyMap;
    private boolean getUpdateLocks;
    private boolean gotRowCount = false;
    private long rowCount = 0L;

    public void init(Object arg1, Object arg2, Object arg3, Object arg4) {
        if (arg3 instanceof Integer) {
            this.init(arg2, null);
            this.tableName = (TableName)arg1;
            this.updateOrDelete = (Integer)arg3;
            this.resultColumns = (ResultColumnList)arg4;
        } else {
            this.init(arg2, arg4);
            this.tableName = (TableName)arg1;
            this.resultColumns = (ResultColumnList)arg3;
        }
        this.setOrigTableName(this.tableName);
        this.templateColumns = this.resultColumns;
    }

    public boolean LOJ_reorderable(int numTables) throws StandardException {
        return false;
    }

    public JBitSet LOJgetReferencedTables(int numTables) throws StandardException {
        JBitSet map = new JBitSet(numTables);
        this.fillInReferencedTableMap(map);
        return map;
    }

    public boolean nextAccessPath(Optimizer optimizer, OptimizablePredicateList predList, RowOrdering rowOrdering) throws StandardException {
        String userSpecifiedIndexName = this.getUserSpecifiedIndexName();
        AccessPath ap = this.getCurrentAccessPath();
        ConglomerateDescriptor currentConglomerateDescriptor = ap.getConglomerateDescriptor();
        optimizer.trace(42, predList == null ? 0 : predList.size(), 0, 0.0, this.getExposedName());
        rowOrdering.removeOptimizable(this.getTableNumber());
        if (userSpecifiedIndexName != null) {
            if (currentConglomerateDescriptor != null) {
                if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                    currentConglomerateDescriptor = null;
                }
            } else {
                optimizer.trace(39, this.tableNumber, 0, 0.0, userSpecifiedIndexName);
                if (StringUtil.SQLToUpperCase(userSpecifiedIndexName).equals("NULL")) {
                    currentConglomerateDescriptor = this.tableDescriptor.getConglomerateDescriptor(this.tableDescriptor.getHeapConglomerateId());
                } else {
                    String conglomerateName;
                    this.getConglomDescs();
                    for (int index = 0; !(index >= this.conglomDescs.length || (conglomerateName = (currentConglomerateDescriptor = this.conglomDescs[index]).getConglomerateName()) != null && conglomerateName.equals(userSpecifiedIndexName)); ++index) {
                    }
                    if (currentConglomerateDescriptor == null) {
                        SanityManager.THROWASSERT("Expected to find match for forced index " + userSpecifiedIndexName);
                    }
                }
                if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                    SanityManager.THROWASSERT("No join strategy found");
                }
            }
        } else if (currentConglomerateDescriptor != null) {
            if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                currentConglomerateDescriptor = this.getNextConglom(currentConglomerateDescriptor);
                this.resetJoinStrategies(optimizer);
                if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                    SanityManager.THROWASSERT("No join strategy found");
                }
            }
        } else {
            currentConglomerateDescriptor = this.getFirstConglom();
            if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                SanityManager.THROWASSERT("No join strategy found");
            }
        }
        if (currentConglomerateDescriptor == null) {
            optimizer.trace(30, this.tableNumber, 0, 0.0, null);
        } else {
            currentConglomerateDescriptor.setColumnNames(this.columnNames);
            optimizer.trace(31, this.tableNumber, 0, 0.0, currentConglomerateDescriptor);
        }
        if (currentConglomerateDescriptor != null) {
            if (!currentConglomerateDescriptor.isIndex()) {
                if (!this.isOneRowResultSet(predList)) {
                    optimizer.trace(33, predList == null ? 0 : predList.size(), 0, 0.0, null);
                    rowOrdering.addUnorderedOptimizable(this);
                } else {
                    optimizer.trace(32, 0, 0, 0.0, null);
                }
            } else {
                IndexRowGenerator irg = currentConglomerateDescriptor.getIndexDescriptor();
                int[] baseColumnPositions = irg.baseColumnPositions();
                boolean[] isAscending = irg.isAscending();
                for (int i = 0; i < baseColumnPositions.length; ++i) {
                    if (rowOrdering.orderedOnColumn(isAscending[i] ? 1 : 2, this.getTableNumber(), baseColumnPositions[i])) continue;
                    rowOrdering.nextOrderPosition(isAscending[i] ? 1 : 2);
                    rowOrdering.addOrderedColumn(isAscending[i] ? 1 : 2, this.getTableNumber(), baseColumnPositions[i]);
                }
            }
        }
        ap.setConglomerateDescriptor(currentConglomerateDescriptor);
        return currentConglomerateDescriptor != null;
    }

    protected boolean canBeOrdered() {
        return true;
    }

    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        optimizer.costOptimizable(this, this.tableDescriptor, this.getCurrentAccessPath().getConglomerateDescriptor(), predList, outerCost);
        return this.getCurrentAccessPath().getCostEstimate();
    }

    public TableDescriptor getTableDescriptor() {
        return this.tableDescriptor;
    }

    public boolean isMaterializable() throws StandardException {
        return true;
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        SanityManager.ASSERT(optimizablePredicate instanceof Predicate, "optimizablePredicate expected to be instanceof Predicate");
        this.restrictionList.addPredicate((Predicate)optimizablePredicate);
        return true;
    }

    public void pullOptPredicates(OptimizablePredicateList optimizablePredicates) throws StandardException {
        for (int i = this.restrictionList.size() - 1; i >= 0; --i) {
            optimizablePredicates.addOptPredicate(this.restrictionList.getOptPredicate(i));
            this.restrictionList.removeOptPredicate(i);
        }
    }

    public boolean isCoveringIndex(ConglomerateDescriptor cd) throws StandardException {
        boolean coveringIndex = true;
        if (!cd.isIndex()) {
            return false;
        }
        IndexRowGenerator irg = cd.getIndexDescriptor();
        int[] baseCols = irg.baseColumnPositions();
        int rclSize = this.resultColumns.size();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(index);
            if (!rc.isReferenced() || rc.getExpression() instanceof ConstantNode) continue;
            coveringIndex = false;
            int colPos = rc.getColumnPosition();
            for (int i = 0; i < baseCols.length; ++i) {
                if (colPos != baseCols[i]) continue;
                coveringIndex = true;
                break;
            }
            if (!coveringIndex) break;
        }
        return coveringIndex;
    }

    public void verifyProperties(DataDictionary dDictionary) throws StandardException {
        if (this.tableProperties == null) {
            return;
        }
        boolean indexSpecified = false;
        boolean constraintSpecified = false;
        ConstraintDescriptor consDesc = null;
        Enumeration<Object> e = this.tableProperties.keys();
        StringUtil.SQLEqualsIgnoreCase(this.tableDescriptor.getSchemaName(), "SYS");
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.tableProperties.get(key);
            if (key.equals("index")) {
                String conglomerateName;
                if (constraintSpecified) {
                    throw StandardException.newException("42Y50", this.getBaseTableName());
                }
                indexSpecified = true;
                if (StringUtil.SQLToUpperCase(value).equals("NULL")) continue;
                ConglomerateDescriptor cd = null;
                ConglomerateDescriptor[] cds = this.tableDescriptor.getConglomerateDescriptors();
                for (int index = 0; !(index >= cds.length || (conglomerateName = (cd = cds[index]).getConglomerateName()) != null && conglomerateName.equals(value)); ++index) {
                    cd = null;
                }
                if (cd == null) {
                    throw StandardException.newException("42Y46", (Object)value, (Object)this.getBaseTableName());
                }
                this.getCompilerContext().createDependency(cd);
                continue;
            }
            if (key.equals("constraint")) {
                if (indexSpecified) {
                    throw StandardException.newException("42Y50", this.getBaseTableName());
                }
                constraintSpecified = true;
                if (StringUtil.SQLToUpperCase(value).equals("NULL")) continue;
                consDesc = dDictionary.getConstraintDescriptorByName(this.tableDescriptor, null, value, false);
                if (consDesc == null || !consDesc.hasBackingIndex()) {
                    throw StandardException.newException("42Y48", (Object)value, (Object)this.getBaseTableName());
                }
                this.getCompilerContext().createDependency(consDesc);
                continue;
            }
            if (key.equals("joinStrategy")) {
                this.userSpecifiedJoinStrategy = StringUtil.SQLToUpperCase(value);
                continue;
            }
            if (key.equals("hashInitialCapacity")) {
                this.initialCapacity = this.getIntProperty(value, key);
                if (this.initialCapacity > 0) continue;
                throw StandardException.newException("42Y59", String.valueOf(this.initialCapacity));
            }
            if (key.equals("hashLoadFactor")) {
                try {
                    this.loadFactor = Float.valueOf(value).floatValue();
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("42Y58", (Object)value, (Object)key);
                }
                if (!((double)this.loadFactor <= 0.0) && !((double)this.loadFactor > 1.0)) continue;
                throw StandardException.newException("42Y60", value);
            }
            if (key.equals("hashMaxCapacity")) {
                this.maxCapacity = this.getIntProperty(value, key);
                if (this.maxCapacity > 0) continue;
                throw StandardException.newException("42Y61", String.valueOf(this.maxCapacity));
            }
            if (key.equals("bulkFetch")) {
                this.bulkFetch = this.getIntProperty(value, key);
                if (this.bulkFetch <= 0) {
                    throw StandardException.newException("42Y64", String.valueOf(this.bulkFetch));
                }
                if (!this.forUpdate()) continue;
                throw StandardException.newException("42Y66");
            }
            throw StandardException.newException("42Y44", (Object)key, (Object)"index, constraint, joinStrategy");
        }
        if (constraintSpecified && consDesc != null) {
            ConglomerateDescriptor cd = dDictionary.getConglomerateDescriptor(consDesc.getConglomerateId());
            String indexName = cd.getConglomerateName();
            this.tableProperties.remove("constraint");
            this.tableProperties.put("index", indexName);
        }
    }

    public String getBaseTableName() {
        return this.tableName.getTableName();
    }

    public void startOptimizing(Optimizer optimizer, RowOrdering rowOrdering) {
        AccessPath ap = this.getCurrentAccessPath();
        AccessPath bestAp = this.getBestAccessPath();
        AccessPath bestSortAp = this.getBestSortAvoidancePath();
        ap.setConglomerateDescriptor(null);
        bestAp.setConglomerateDescriptor(null);
        bestSortAp.setConglomerateDescriptor(null);
        ap.setCoveringIndexScan(false);
        bestAp.setCoveringIndexScan(false);
        bestSortAp.setCoveringIndexScan(false);
        ap.setLockMode(0);
        bestAp.setLockMode(0);
        bestSortAp.setLockMode(0);
        CostEstimate costEstimate = this.getCostEstimate(optimizer);
        ap.setCostEstimate(costEstimate);
        costEstimate.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        super.startOptimizing(optimizer, rowOrdering);
    }

    public int convertAbsoluteToRelativeColumnPosition(int absolutePosition) {
        return this.mapAbsoluteToRelativeColumnPosition(absolutePosition);
    }

    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        boolean statisticsForTable = false;
        boolean statisticsForConglomerate = false;
        PredicateList unknownPredicateList = null;
        if (optimizer.useStatistics() && predList != null) {
            statisticsForConglomerate = this.tableDescriptor.statisticsExist(cd);
            statisticsForTable = this.tableDescriptor.statisticsExist(null);
            unknownPredicateList = new PredicateList();
            predList.copyPredicatesToOtherList(unknownPredicateList);
        }
        AccessPath currentAccessPath = this.getCurrentAccessPath();
        JoinStrategy currentJoinStrategy = currentAccessPath.getJoinStrategy();
        optimizer.trace(38, this.tableNumber, 0, 0.0, cd);
        double tableUniquenessFactor = optimizer.uniqueJoinWithOuterTable(predList);
        boolean oneRowResultSetForSomeConglom = this.isOneRowResultSet(predList);
        this.baseTableRestrictionList.removeAllElements();
        currentJoinStrategy.getBasePredicates(predList, this.baseTableRestrictionList, this);
        StoreCostController scc = this.getStoreCostController(cd);
        CostEstimate costEstimate = this.getScratchCostEstimate(optimizer);
        if (this.isOneRowResultSet(cd, this.baseTableRestrictionList)) {
            OptimizablePredicate pred;
            rowOrdering.optimizableAlwaysOrdered(this);
            this.singleScanRowCount = 1.0;
            double cost = scc.getFetchFromFullKeyCost(null, 0);
            optimizer.trace(40, this.tableNumber, 0, cost, null);
            costEstimate.setCost(cost, 1.0, 1.0);
            double newCost = costEstimate.getEstimatedCost();
            if (currentJoinStrategy.multiplyBaseCostByOuterRows()) {
                newCost *= outerCost.rowCount();
            }
            costEstimate.setCost(newCost, costEstimate.rowCount() * outerCost.rowCount(), costEstimate.singleScanRowCount());
            boolean constantStartStop = true;
            for (int i = 0; i < predList.size() && ((pred = predList.getOptPredicate(i)).isStartKey() || pred.isStopKey()); ++i) {
                if (pred.getReferencedMap().hasSingleBitSet()) continue;
                constantStartStop = false;
                break;
            }
            if (constantStartStop) {
                currentAccessPath.setLockMode(6);
                optimizer.trace(37, 0, 0, 0.0, null);
            } else {
                this.setLockingBasedOnThreshold(optimizer, costEstimate.rowCount());
            }
            optimizer.trace(23, this.tableNumber, 0, outerCost.rowCount(), costEstimate);
            if (cd.isIndex() && !this.isCoveringIndex(cd)) {
                double singleFetchCost = this.getBaseCostController().getFetchFromRowLocationCost(null, 0);
                cost = singleFetchCost * costEstimate.rowCount();
                costEstimate.setEstimatedCost(costEstimate.getEstimatedCost() + cost);
                optimizer.trace(36, this.tableNumber, 0, cost, null);
            }
        } else {
            double maxRows;
            double maxRows2;
            double scanUniquenessFactor;
            int stopOperator;
            int startOperator;
            OptimizablePredicate pred;
            double extraFirstColumnSelectivity = 1.0;
            double extraStartStopSelectivity = 1.0;
            double extraQualifierSelectivity = 1.0;
            double extraNonQualifierSelectivity = 1.0;
            double statStartStopSelectivity = 1.0;
            double statCompositeSelectivity = 1.0;
            int numExtraFirstColumnPreds = 0;
            int numExtraStartStopPreds = 0;
            int numExtraQualifiers = 0;
            int numExtraNonQualifiers = 0;
            boolean startGap = false;
            boolean stopGap = false;
            boolean seenFirstColumn = false;
            boolean constantStartStop = true;
            boolean startStopFound = false;
            int startKeyNum = 0;
            int stopKeyNum = 0;
            int predListSize = predList != null ? this.baseTableRestrictionList.size() : 0;
            int startStopPredCount = 0;
            ColumnReference firstColumn = null;
            for (int i = 0; i < predListSize; ++i) {
                pred = this.baseTableRestrictionList.getOptPredicate(i);
                boolean startKey = pred.isStartKey();
                boolean stopKey = pred.isStopKey();
                if (startKey || stopKey) {
                    startStopFound = true;
                    if (!pred.getReferencedMap().hasSingleBitSet()) {
                        constantStartStop = false;
                    }
                    boolean knownConstant = pred.compareWithKnownConstant(this, true);
                    if (startKey) {
                        if (knownConstant && !startGap) {
                            ++startKeyNum;
                            if (unknownPredicateList != null) {
                                unknownPredicateList.removeOptPredicate(pred);
                            }
                        } else {
                            startGap = true;
                        }
                    }
                    if (stopKey) {
                        if (knownConstant && !stopGap) {
                            ++stopKeyNum;
                            if (unknownPredicateList != null) {
                                unknownPredicateList.removeOptPredicate(pred);
                            }
                        } else {
                            stopGap = true;
                        }
                    }
                    if (!startGap && !stopGap || this.baseTableRestrictionList.isRedundantPredicate(i)) continue;
                    if (startKey && stopKey) {
                        ++startStopPredCount;
                    }
                    if (pred.getIndexPosition() == 0) {
                        extraFirstColumnSelectivity *= pred.selectivity(this);
                        if (seenFirstColumn) continue;
                        ValueNode relNode = ((Predicate)pred).getAndNode().getLeftOperand();
                        if (relNode instanceof BinaryRelationalOperatorNode) {
                            firstColumn = ((BinaryRelationalOperatorNode)relNode).getColumnOperand(this);
                        }
                        seenFirstColumn = true;
                        continue;
                    }
                    extraStartStopSelectivity *= pred.selectivity(this);
                    ++numExtraStartStopPreds;
                    continue;
                }
                if (this.baseTableRestrictionList.isRedundantPredicate(i)) continue;
                if (pred instanceof Predicate) {
                    ColumnReference cr;
                    ValueNode receiver;
                    LikeEscapeOperatorNode likeNode;
                    ValueNode leftOpnd = ((Predicate)pred).getAndNode().getLeftOperand();
                    if (firstColumn != null && leftOpnd instanceof LikeEscapeOperatorNode && (likeNode = (LikeEscapeOperatorNode)leftOpnd).getLeftOperand().requiresTypeFromContext() && (receiver = likeNode.getReceiver()) instanceof ColumnReference && (cr = (ColumnReference)receiver).getTableNumber() == firstColumn.getTableNumber() && cr.getColumnNumber() == firstColumn.getColumnNumber()) {
                        extraFirstColumnSelectivity *= 0.2;
                    }
                }
                if (pred.isQualifier()) {
                    extraQualifierSelectivity *= pred.selectivity(this);
                    ++numExtraQualifiers;
                } else {
                    extraNonQualifierSelectivity *= pred.selectivity(this);
                    ++numExtraNonQualifiers;
                }
                startGap = true;
                stopGap = true;
            }
            if (unknownPredicateList != null && (statCompositeSelectivity = unknownPredicateList.selectivity(this)) == -1.0) {
                statCompositeSelectivity = 1.0;
            }
            if (seenFirstColumn && statisticsForConglomerate && startStopPredCount > 0) {
                statStartStopSelectivity = this.tableDescriptor.selectivityForConglomerate(cd, startStopPredCount);
            }
            extraNonQualifierSelectivity *= currentJoinStrategy.nonBasePredicateSelectivity(this, predList);
            DataValueDescriptor[] startKeys = startKeyNum > 0 ? new DataValueDescriptor[startKeyNum] : null;
            DataValueDescriptor[] stopKeys = stopKeyNum > 0 ? new DataValueDescriptor[stopKeyNum] : null;
            startKeyNum = 0;
            stopKeyNum = 0;
            startGap = false;
            stopGap = false;
            InListOperatorNode ssKeySourceInList = null;
            for (int i = 0; i < predListSize; ++i) {
                pred = this.baseTableRestrictionList.getOptPredicate(i);
                boolean startKey = pred.isStartKey();
                boolean stopKey = pred.isStopKey();
                if (startKey || stopKey) {
                    if (ssKeySourceInList != null && ((Predicate)pred).isInListProbePredicate()) {
                        SanityManager.THROWASSERT("Found multiple probe predicate start/stop keys for conglomerate '" + cd.getConglomerateName() + "' when at most one was expected.");
                    }
                    ssKeySourceInList = ((Predicate)pred).getSourceInList(true);
                    boolean knownConstant = pred.compareWithKnownConstant(this, true);
                    if (startKey) {
                        if (knownConstant && !startGap) {
                            startKeys[startKeyNum] = pred.getCompareValue(this);
                            ++startKeyNum;
                        } else {
                            startGap = true;
                        }
                    }
                    if (!stopKey) continue;
                    if (knownConstant && !stopGap) {
                        stopKeys[stopKeyNum] = pred.getCompareValue(this);
                        ++stopKeyNum;
                        continue;
                    }
                    stopGap = true;
                    continue;
                }
                startGap = true;
                stopGap = true;
            }
            if (this.baseTableRestrictionList != null) {
                startOperator = this.baseTableRestrictionList.startOperator(this);
                stopOperator = this.baseTableRestrictionList.stopOperator(this);
            } else {
                startOperator = 0;
                stopOperator = 0;
            }
            DataValueDescriptor[] rowTemplate = this.getRowTemplate(cd, this.getBaseCostController());
            long baseRC = startKeys != null || stopKeys != null ? this.baseRowCount() : this.baseRowCount() + 5L;
            scc.getScanCost(currentJoinStrategy.scanCostType(), baseRC, 1, this.forUpdate(), null, rowTemplate, startKeys, startOperator, stopKeys, stopOperator, false, 0, costEstimate);
            double initialPositionCost = 0.0;
            if (cd.isIndex()) {
                initialPositionCost = scc.getFetchFromFullKeyCost(null, 0);
                if (oneRowResultSetForSomeConglom && costEstimate.rowCount() <= 1.0) {
                    costEstimate.setCost(costEstimate.getEstimatedCost() * 2.0, costEstimate.rowCount() + 2.0, costEstimate.singleScanRowCount() + 2.0);
                }
            }
            optimizer.trace(53, this.tableNumber, 0, 0.0, cd);
            optimizer.trace(54, this.tableNumber, 0, 0.0, costEstimate);
            optimizer.trace(55, numExtraFirstColumnPreds, 0, extraFirstColumnSelectivity, null);
            optimizer.trace(56, numExtraStartStopPreds, 0, extraStartStopSelectivity, null);
            optimizer.trace(59, startStopPredCount, 0, statStartStopSelectivity, null);
            optimizer.trace(57, numExtraQualifiers, 0, extraQualifierSelectivity, null);
            optimizer.trace(58, numExtraNonQualifiers, 0, extraNonQualifierSelectivity, null);
            double initialRowCount = costEstimate.rowCount();
            if (statStartStopSelectivity != 1.0) {
                costEstimate.setCost(this.scanCostAfterSelectivity(costEstimate.getEstimatedCost(), initialPositionCost, statStartStopSelectivity, oneRowResultSetForSomeConglom), costEstimate.rowCount() * statStartStopSelectivity, costEstimate.singleScanRowCount() * statStartStopSelectivity);
                optimizer.trace(62, this.tableNumber, 0, 0.0, costEstimate);
            } else {
                if (extraFirstColumnSelectivity != 1.0) {
                    costEstimate.setCost(this.scanCostAfterSelectivity(costEstimate.getEstimatedCost(), initialPositionCost, extraFirstColumnSelectivity, oneRowResultSetForSomeConglom), costEstimate.rowCount() * extraFirstColumnSelectivity, costEstimate.singleScanRowCount() * extraFirstColumnSelectivity);
                    optimizer.trace(41, this.tableNumber, 0, 0.0, costEstimate);
                }
                if (extraStartStopSelectivity != 1.0) {
                    costEstimate.setCost(costEstimate.getEstimatedCost(), costEstimate.rowCount() * extraStartStopSelectivity, costEstimate.singleScanRowCount() * extraStartStopSelectivity);
                    optimizer.trace(45, this.tableNumber, 0, 0.0, costEstimate);
                }
            }
            if (ssKeySourceInList != null) {
                int listSize = ssKeySourceInList.getRightOperandList().size();
                double rc = costEstimate.rowCount() * (double)listSize;
                double ssrc = costEstimate.singleScanRowCount() * (double)listSize;
                costEstimate.setCost(costEstimate.getEstimatedCost() * (double)listSize, rc > initialRowCount ? initialRowCount : rc, ssrc > initialRowCount ? initialRowCount : ssrc);
            }
            if (!startStopFound) {
                currentAccessPath.setLockMode(7);
                optimizer.trace(35, 0, 0, 0.0, null);
            } else {
                double rowsTouched = costEstimate.rowCount();
                if (!constantStartStop && currentJoinStrategy.multiplyBaseCostByOuterRows()) {
                    double r = this.baseRowCount();
                    if (r > 0.0) {
                        double rowsTouchedAllScans;
                        double s = costEstimate.rowCount();
                        double o = outerCost.rowCount();
                        double pRowsNotTouchedPerScan = 1.0 - s / r;
                        double pRowsNotTouchedAllScans = Math.pow(pRowsNotTouchedPerScan, o);
                        double pRowsTouchedAllScans = 1.0 - pRowsNotTouchedAllScans;
                        rowsTouched = rowsTouchedAllScans = r * pRowsTouchedAllScans;
                    } else {
                        rowsTouched = optimizer.tableLockThreshold() + 1;
                    }
                }
                this.setLockingBasedOnThreshold(optimizer, rowsTouched);
            }
            if (cd.isIndex() && !this.isCoveringIndex(cd)) {
                double singleFetchCost = this.getBaseCostController().getFetchFromRowLocationCost(null, 0);
                double cost = singleFetchCost * costEstimate.rowCount();
                costEstimate.setEstimatedCost(costEstimate.getEstimatedCost() + cost);
                optimizer.trace(48, this.tableNumber, 0, 0.0, costEstimate);
            }
            if (extraQualifierSelectivity != 1.0) {
                costEstimate.setCost(costEstimate.getEstimatedCost(), costEstimate.rowCount() * extraQualifierSelectivity, costEstimate.singleScanRowCount() * extraQualifierSelectivity);
                optimizer.trace(46, this.tableNumber, 0, 0.0, costEstimate);
            }
            this.singleScanRowCount = costEstimate.singleScanRowCount();
            double newCost = costEstimate.getEstimatedCost();
            double rowCount = costEstimate.rowCount();
            if (currentJoinStrategy.multiplyBaseCostByOuterRows()) {
                newCost *= outerCost.rowCount();
            }
            rowCount *= outerCost.rowCount();
            initialRowCount *= outerCost.rowCount();
            if (oneRowResultSetForSomeConglom && outerCost.rowCount() < rowCount) {
                rowCount = outerCost.rowCount();
            }
            if (cd.isIndex() && startStopFound && !constantStartStop && (scanUniquenessFactor = optimizer.uniqueJoinWithOuterTable(this.baseTableRestrictionList)) > 0.0 && rowCount > (maxRows2 = (double)this.baseRowCount() / scanUniquenessFactor)) {
                newCost *= maxRows2 / rowCount;
            }
            if (tableUniquenessFactor > 0.0 && rowCount > (maxRows = (double)this.baseRowCount() / tableUniquenessFactor)) {
                rowCount = maxRows;
            }
            costEstimate.setCost(newCost, rowCount, costEstimate.singleScanRowCount());
            optimizer.trace(23, this.tableNumber, 0, outerCost.rowCount(), costEstimate);
            double rc = -1.0;
            double src = -1.0;
            if (this.existsBaseTable) {
                src = 1.0;
                rc = 1.0;
            } else if (extraNonQualifierSelectivity != 1.0) {
                rc = oneRowResultSetForSomeConglom ? costEstimate.rowCount() : costEstimate.rowCount() * extraNonQualifierSelectivity;
                src = costEstimate.singleScanRowCount() * extraNonQualifierSelectivity;
            }
            if (rc != -1.0) {
                costEstimate.setCost(costEstimate.getEstimatedCost(), rc, src);
                optimizer.trace(47, this.tableNumber, 0, 0.0, costEstimate);
            }
            if (statisticsForTable && !oneRowResultSetForSomeConglom && statCompositeSelectivity != 1.0) {
                double compositeStatRC = initialRowCount * statCompositeSelectivity;
                optimizer.trace(61, 0, 0, statCompositeSelectivity, null);
                if (!(tableUniquenessFactor > 0.0) || !(compositeStatRC > (double)this.baseRowCount() * tableUniquenessFactor)) {
                    costEstimate.setCost(costEstimate.getEstimatedCost(), compositeStatRC, this.existsBaseTable ? 1.0 : compositeStatRC / outerCost.rowCount());
                    optimizer.trace(60, this.tableNumber, 0, 0.0, costEstimate);
                }
            }
        }
        currentJoinStrategy.putBasePredicates(predList, this.baseTableRestrictionList);
        return costEstimate;
    }

    private double scanCostAfterSelectivity(double originalScanCost, double initialPositionCost, double selectivity, boolean anotherIndexUnique) throws StandardException {
        double afterInitialCost;
        double minSelectivity;
        double r;
        if (anotherIndexUnique && (r = (double)this.baseRowCount()) > 0.0 && (minSelectivity = 2.0 / r) > selectivity) {
            selectivity = minSelectivity;
        }
        if ((afterInitialCost = (originalScanCost - initialPositionCost) * selectivity) < 0.0) {
            afterInitialCost = 0.0;
        }
        return initialPositionCost + afterInitialCost;
    }

    private void setLockingBasedOnThreshold(Optimizer optimizer, double rowsTouched) {
        this.getCurrentAccessPath().setLockMode(6);
    }

    public boolean isBaseTable() {
        return true;
    }

    public boolean forUpdate() {
        return this.updateOrDelete != 0 || this.cursorTargetTable || this.getUpdateLocks;
    }

    public int initialCapacity() {
        return this.initialCapacity;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public boolean memoryUsageOK(double rowCount, int maxMemoryPerTable) throws StandardException {
        return super.memoryUsageOK(this.singleScanRowCount, maxMemoryPerTable);
    }

    public boolean isTargetTable() {
        return this.updateOrDelete != 0;
    }

    public double uniqueJoin(OptimizablePredicateList predList) throws StandardException {
        double retval = -1.0;
        PredicateList pl = (PredicateList)predList;
        int numColumns = this.getTableDescriptor().getNumberOfColumns();
        int tableNumber = this.getTableNumber();
        int[] tableNumbers = new int[]{};
        JBitSet[] tableColMap = new JBitSet[]{new JBitSet(numColumns + 1)};
        pl.checkTopPredicatesForEqualsConditions(tableNumber, null, tableNumbers, tableColMap, false);
        if (this.supersetOfUniqueIndex(tableColMap)) {
            retval = this.getBestAccessPath().getCostEstimate().singleScanRowCount();
        }
        return retval;
    }

    public boolean isOneRowScan() throws StandardException {
        if (this.existsBaseTable) {
            return false;
        }
        return super.isOneRowScan();
    }

    public boolean legalJoinOrder(JBitSet assignedTableMap) {
        if (this.existsBaseTable) {
            return assignedTableMap.contains(this.dependencyMap);
        }
        return true;
    }

    public String toString() {
        return "tableName: " + (this.tableName != null ? this.tableName.toString() : "null") + "\n" + "tableDescriptor: " + this.tableDescriptor + "\n" + "updateOrDelete: " + this.updateOrDelete + "\n" + (this.tableProperties != null ? this.tableProperties.toString() : "null") + "\n" + "existsBaseTable: " + this.existsBaseTable + "\n" + "dependencyMap: " + (this.dependencyMap != null ? this.dependencyMap.toString() : "null") + "\n" + super.toString();
    }

    boolean getExistsBaseTable() {
        return this.existsBaseTable;
    }

    void setExistsBaseTable(boolean existsBaseTable, JBitSet dependencyMap, boolean isNotExists) {
        this.existsBaseTable = existsBaseTable;
        this.isNotExists = isNotExists;
        this.dependencyMap = existsBaseTable ? dependencyMap : null;
    }

    void clearDependency(Vector locations) {
        if (this.dependencyMap != null) {
            for (int i = 0; i < locations.size(); ++i) {
                this.dependencyMap.clear((Integer)locations.elementAt(i));
            }
        }
    }

    public void setTableProperties(Properties tableProperties) {
        this.tableProperties = tableProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        TableDescriptor tableDescriptor = this.bindTableDescriptor();
        if (tableDescriptor.getTableType() == 5) {
            ResultSetNode vtiNode = this.getNodeFactory().mapTableAsVTI(tableDescriptor, this.getCorrelationName(), this.resultColumns, this.getProperties(), this.getContextManager());
            return vtiNode.bindNonVTITables(dataDictionary, fromListParam);
        }
        ResultColumnList derivedRCL = this.resultColumns;
        this.restrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.baseTableRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        CompilerContext compilerContext = this.getCompilerContext();
        this.templateColumns = this.resultColumns = this.genResultColList();
        if (tableDescriptor.getTableType() == 2) {
            ViewDescriptor vd = dataDictionary.getViewDescriptor(tableDescriptor);
            SchemaDescriptor compSchema = dataDictionary.getSchemaDescriptor(vd.getCompSchemaId(), null);
            compilerContext.pushCompilationSchema(compSchema);
            try {
                compilerContext.createDependency(vd);
                SanityManager.ASSERT(vd != null, "vd not expected to be null for " + this.tableName);
                CreateViewNode cvn = (CreateViewNode)this.parseStatement(vd.getViewText(), false);
                ResultSetNode rsn = cvn.getParsedQueryExpression();
                if (rsn.getResultColumns().containsAllResultColumn()) {
                    this.resultColumns.setCountMismatchAllowed(true);
                }
                for (int i = 0; i < this.resultColumns.size(); ++i) {
                    ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(i);
                    if (!rc.isPrivilegeCollectionRequired()) continue;
                    compilerContext.addRequiredColumnPriv(rc.getTableColumnDescriptor());
                }
                FromSubquery fsq = (FromSubquery)this.getNodeFactory().getNode(136, rsn, this.correlationName != null ? this.correlationName : this.getOrigTableName().getTableName(), this.resultColumns, this.tableProperties, this.getContextManager());
                fsq.setLevel(this.level);
                fsq.disablePrivilegeCollection();
                fsq.setOrigTableName(this.getOrigTableName());
                fsq.setOrigCompilationSchema(compSchema);
                ResultSetNode resultSetNode = fsq.bindNonVTITables(dataDictionary, fromListParam);
                return resultSetNode;
            }
            finally {
                compilerContext.popCompilationSchema();
            }
        }
        compilerContext.createDependency(tableDescriptor);
        this.baseConglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(tableDescriptor.getHeapConglomerateId());
        this.columnNames = this.resultColumns.getColumnNames();
        if (derivedRCL != null) {
            this.resultColumns.propagateDCLInfo(derivedRCL, this.origTableName.getFullTableName());
        }
        if (this.tableNumber == -1) {
            this.tableNumber = compilerContext.getNextTableNumber();
        }
        return this;
    }

    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        String fullName;
        String ourSchemaName = this.getOrigTableName().getSchemaName();
        String string = fullName = schemaName != null ? schemaName + '.' + name : name;
        if (exactMatch) {
            if (schemaName != null && ourSchemaName == null || schemaName == null && ourSchemaName != null) {
                return null;
            }
            if (this.getExposedName().equals(fullName)) {
                return this;
            }
            return null;
        }
        if (this.getExposedName().equals(fullName)) {
            return this;
        }
        if (schemaName != null && ourSchemaName != null || schemaName == null && ourSchemaName == null) {
            return null;
        }
        if (schemaName != null && ourSchemaName == null) {
            if (this.tableName.equals(this.origTableName) && !schemaName.equals(this.tableDescriptor.getSchemaDescriptor().getSchemaName())) {
                return null;
            }
            if (!this.getExposedName().equals(name)) {
                return null;
            }
            if (!this.getExposedName().equals(this.getOrigTableName().getTableName())) {
                return null;
            }
            return this;
        }
        if (!this.getExposedName().equals(this.getOrigTableName().getSchemaName() + "." + name)) {
            return null;
        }
        return this;
    }

    private TableDescriptor bindTableDescriptor() throws StandardException {
        String schemaName = this.tableName.getSchemaName();
        SchemaDescriptor sd = this.getSchemaDescriptor(schemaName);
        this.tableDescriptor = this.getTableDescriptor(this.tableName.getTableName(), sd);
        if (this.tableDescriptor == null) {
            TableName synonymTab = this.resolveTableToSynonym(this.tableName);
            if (synonymTab == null) {
                throw StandardException.newException("42X05", this.tableName);
            }
            this.tableName = synonymTab;
            sd = this.getSchemaDescriptor(this.tableName.getSchemaName());
            this.tableDescriptor = this.getTableDescriptor(synonymTab.getTableName(), sd);
            if (this.tableDescriptor == null) {
                throw StandardException.newException("42X05", this.tableName);
            }
        }
        return this.tableDescriptor;
    }

    public void bindExpressions(FromList fromListParam) throws StandardException {
    }

    public void bindResultColumns(FromList fromListParam) throws StandardException {
    }

    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        TableName exposedTableName;
        ResultColumn resultColumn = null;
        TableName columnsTableName = columnReference.getTableNameNode();
        if (columnsTableName != null && columnsTableName.getSchemaName() == null && this.correlationName == null) {
            columnsTableName.bind(this.getDataDictionary());
        }
        if ((exposedTableName = this.getExposedTableName()).getSchemaName() == null && this.correlationName == null) {
            exposedTableName.bind(this.getDataDictionary());
        }
        if ((columnsTableName == null || columnsTableName.equals(exposedTableName)) && (resultColumn = this.resultColumns.getResultColumn(columnReference.getColumnName())) != null) {
            columnReference.setTableNumber(this.tableNumber);
            if (this.tableDescriptor != null) {
                FormatableBitSet referencedColumnMap = this.tableDescriptor.getReferencedColumnMap();
                if (referencedColumnMap == null) {
                    referencedColumnMap = new FormatableBitSet(this.tableDescriptor.getNumberOfColumns() + 1);
                }
                referencedColumnMap.set(resultColumn.getColumnPosition());
                this.tableDescriptor.setReferencedColumnMap(referencedColumnMap);
            }
        }
        return resultColumn;
    }

    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.referencedTableMap = new JBitSet(numTables);
        this.referencedTableMap.set(this.tableNumber);
        return this.genProjectRestrict(numTables);
    }

    protected ResultSetNode genProjectRestrict(int numTables) throws StandardException {
        ResultColumnList prRCList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        prRCList.genVirtualColumnNodes(this, this.resultColumns, false);
        prRCList.doProjection();
        return (ResultSetNode)this.getNodeFactory().getNode(151, this, prRCList, null, null, null, null, null, this.getContextManager());
    }

    public ResultSetNode changeAccessPath() throws StandardException {
        AccessPath ap = this.getTrulyTheBestAccessPath();
        ConglomerateDescriptor trulyTheBestConglomerateDescriptor = ap.getConglomerateDescriptor();
        JoinStrategy trulyTheBestJoinStrategy = ap.getJoinStrategy();
        Optimizer optimizer = ap.getOptimizer();
        optimizer.trace(34, this.tableNumber, 0, 0.0, null);
        SanityManager.ASSERT(trulyTheBestConglomerateDescriptor != null, "Should only modify access path after conglomerate has been chosen.");
        if (this.bulkFetch != -1) {
            if (!trulyTheBestJoinStrategy.bulkFetchOK()) {
                throw StandardException.newException("42Y65", trulyTheBestJoinStrategy.getName());
            }
            if (trulyTheBestJoinStrategy.ignoreBulkFetch()) {
                this.disableBulkFetch();
            } else if (this.isOneRowResultSet()) {
                this.disableBulkFetch();
            }
        }
        if (this.bulkFetch == 1) {
            this.disableBulkFetch();
        }
        this.restrictionList.removeRedundantPredicates();
        this.storeRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.nonStoreRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.requalificationRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        trulyTheBestJoinStrategy.divideUpPredicateLists(this, this.restrictionList, this.storeRestrictionList, this.nonStoreRestrictionList, this.requalificationRestrictionList, this.getDataDictionary());
        for (int i = 0; i < this.restrictionList.size(); ++i) {
            Predicate pred = (Predicate)this.restrictionList.elementAt(i);
            if (!pred.isInListProbePredicate() || !pred.isStartKey()) continue;
            this.disableBulkFetch();
            this.multiProbing = true;
            break;
        }
        if (!(!trulyTheBestJoinStrategy.bulkFetchOK() || trulyTheBestJoinStrategy.ignoreBulkFetch() || this.bulkFetchTurnedOff || this.bulkFetch != -1 || this.forUpdate() || this.isOneRowResultSet() || this.getLevel() != 0)) {
            this.bulkFetch = this.getDefaultBulkFetch();
        }
        this.getCompilerContext().createDependency(trulyTheBestConglomerateDescriptor);
        if (!trulyTheBestConglomerateDescriptor.isIndex()) {
            boolean isSysstatements = this.tableName.equals("SYS", "SYSSTATEMENTS");
            this.templateColumns = this.resultColumns;
            this.referencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, isSysstatements, false);
            this.resultColumns = this.resultColumns.compactColumns(this.cursorTargetTable, isSysstatements);
            return this;
        }
        if (ap.getCoveringIndexScan() && !this.cursorTargetTable()) {
            this.resultColumns = this.newResultColumns(this.resultColumns, trulyTheBestConglomerateDescriptor, this.baseConglomerateDescriptor, false);
            this.templateColumns = this.newResultColumns(this.resultColumns, trulyTheBestConglomerateDescriptor, this.baseConglomerateDescriptor, false);
            this.templateColumns.addRCForRID();
            if (this.forUpdate()) {
                this.resultColumns.addRCForRID();
            }
            this.referencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, true, false);
            this.resultColumns = this.resultColumns.compactColumns(this.cursorTargetTable, true);
            this.resultColumns.setIndexRow(this.baseConglomerateDescriptor.getConglomerateNumber(), this.forUpdate());
            return this;
        }
        this.getCompilerContext().createDependency(this.baseConglomerateDescriptor);
        if (this.bulkFetch != -1) {
            this.restrictionList.copyPredicatesToOtherList(this.requalificationRestrictionList);
        }
        ResultColumnList newResultColumns = this.newResultColumns(this.resultColumns, trulyTheBestConglomerateDescriptor, this.baseConglomerateDescriptor, true);
        FormatableBitSet indexReferencedCols = null;
        FormatableBitSet heapReferencedCols = null;
        if (this.bulkFetch == -1 && (this.requalificationRestrictionList == null || this.requalificationRestrictionList.size() == 0)) {
            indexReferencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, true, false);
            heapReferencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, true, true);
            if (heapReferencedCols != null) {
                indexReferencedCols.xor(heapReferencedCols);
            }
        } else {
            heapReferencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, true, false);
        }
        ResultColumnList heapRCL = this.resultColumns.compactColumns(this.cursorTargetTable, false);
        ResultSetNode retval = (ResultSetNode)this.getNodeFactory().getNode(149, this, this.baseConglomerateDescriptor, heapRCL, new Boolean(this.cursorTargetTable), heapReferencedCols, indexReferencedCols, this.requalificationRestrictionList, new Boolean(this.forUpdate()), this.tableProperties, this.getContextManager());
        this.resultColumns = newResultColumns;
        this.templateColumns = this.newResultColumns(this.resultColumns, trulyTheBestConglomerateDescriptor, this.baseConglomerateDescriptor, false);
        if (this.bulkFetch != -1) {
            this.resultColumns.markAllUnreferenced();
            this.storeRestrictionList.markReferencedColumns();
            if (this.nonStoreRestrictionList != null) {
                this.nonStoreRestrictionList.markReferencedColumns();
            }
        }
        this.resultColumns.addRCForRID();
        this.templateColumns.addRCForRID();
        this.referencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, false, false);
        this.resultColumns = this.resultColumns.compactColumns(this.cursorTargetTable, false);
        this.resultColumns.setIndexRow(this.baseConglomerateDescriptor.getConglomerateNumber(), this.forUpdate());
        this.getUpdateLocks = this.cursorTargetTable;
        this.cursorTargetTable = false;
        return retval;
    }

    private ResultColumnList newResultColumns(ResultColumnList oldColumns, ConglomerateDescriptor idxCD, ConglomerateDescriptor heapCD, boolean cloneRCs) throws StandardException {
        IndexRowGenerator irg = idxCD.getIndexDescriptor();
        int[] baseCols = irg.baseColumnPositions();
        ResultColumnList newCols = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        for (int i = 0; i < baseCols.length; ++i) {
            ResultColumn newCol;
            int basePosition = baseCols[i];
            ResultColumn oldCol = oldColumns.getResultColumn(basePosition);
            SanityManager.ASSERT(oldCol != null, "Couldn't find base column " + basePosition + "\n.  RCL is\n" + oldColumns);
            if (cloneRCs) {
                newCol = oldCol.cloneMe();
                oldCol.setExpression((ValueNode)this.getNodeFactory().getNode(107, this, newCol, ReuseFactory.getInteger(oldCol.getVirtualColumnId()), this.getContextManager()));
            } else {
                newCol = oldCol;
            }
            newCols.addResultColumn(newCol);
        }
        newCols.setIndexRow(heapCD.getConglomerateNumber(), this.forUpdate());
        return newCols;
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateResultSet(acb, mb);
        if (this.cursorTargetTable) {
            acb.rememberCursorTarget(mb);
        }
    }

    public void generateResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.getTrulyTheBestAccessPath().getConglomerateDescriptor() != null);
        this.assignResultSetNumber();
        if (this.specialMaxScan) {
            this.generateMaxSpecialResultSet(acb, mb);
            return;
        }
        if (this.distinctScan) {
            this.generateDistinctScan(acb, mb);
            return;
        }
        if (this.raDependentScan) {
            this.generateRefActionDependentTableScan(acb, mb);
            return;
        }
        JoinStrategy trulyTheBestJoinStrategy = this.getTrulyTheBestAccessPath().getJoinStrategy();
        acb.pushGetResultSetFactoryExpression(mb);
        int nargs = this.getScanArguments(acb, mb);
        mb.callMethod((short)185, null, trulyTheBestJoinStrategy.resultSetMethodName(this.bulkFetch != -1, this.multiProbing), "org.apache.derby.iapi.sql.execute.NoPutResultSet", nargs);
        if (this.updateOrDelete == 1 || this.updateOrDelete == 2) {
            mb.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
            mb.putField(acb.getRowLocationScanResultSetName(), "org.apache.derby.iapi.sql.execute.CursorResultSet");
            mb.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        }
    }

    public CostEstimate getFinalCostEstimate() {
        return this.getTrulyTheBestAccessPath().getCostEstimate();
    }

    private void pushIndexName(ConglomerateDescriptor cd, MethodBuilder mb) throws StandardException {
        if (cd.isConstraint()) {
            DataDictionary dd = this.getDataDictionary();
            ConstraintDescriptor constraintDesc = dd.getConstraintDescriptor(this.tableDescriptor, cd.getUUID());
            mb.push(constraintDesc.getConstraintName());
        } else if (cd.isIndex()) {
            mb.push(cd.getConglomerateName());
        } else {
            mb.pushNull("java.lang.String");
        }
    }

    private void generateMaxSpecialResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        ConglomerateDescriptor cd = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        CostEstimate costEstimate = this.getFinalCostEstimate();
        int colRefItem = this.referencedCols == null ? -1 : acb.addItem(this.referencedCols);
        boolean tableLockGranularity = this.tableDescriptor.getLockGranularity() == 'T';
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.push(this.getResultSetNumber());
        this.resultColumns.generateHolder(acb, mb, this.referencedCols, null);
        mb.push(cd.getConglomerateNumber());
        mb.push(this.tableDescriptor.getName());
        if (this.tableProperties != null) {
            mb.push(org.apache.derby.iapi.util.PropertyUtil.sortProperties(this.tableProperties));
        } else {
            mb.pushNull("java.lang.String");
        }
        this.pushIndexName(cd, mb);
        mb.push(colRefItem);
        mb.push(this.getTrulyTheBestAccessPath().getLockMode());
        mb.push(tableLockGranularity);
        mb.push(this.getCompilerContext().getScanIsolationLevel());
        mb.push(costEstimate.singleScanRowCount());
        mb.push(costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getLastIndexKeyResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 13);
    }

    private void generateDistinctScan(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int index;
        ConglomerateDescriptor cd = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        CostEstimate costEstimate = this.getFinalCostEstimate();
        int colRefItem = this.referencedCols == null ? -1 : acb.addItem(this.referencedCols);
        boolean tableLockGranularity = this.tableDescriptor.getLockGranularity() == 'T';
        int[] hashKeyColumns = new int[this.resultColumns.size()];
        if (this.referencedCols == null) {
            for (index = 0; index < hashKeyColumns.length; ++index) {
                hashKeyColumns[index] = index;
            }
        } else {
            index = 0;
            int colNum = this.referencedCols.anySetBit();
            while (colNum != -1) {
                hashKeyColumns[index++] = colNum;
                colNum = this.referencedCols.anySetBit(colNum);
            }
        }
        Object[] fihArray = FormatableIntHolder.getFormatableIntHolders(hashKeyColumns);
        FormatableArrayHolder hashKeyHolder = new FormatableArrayHolder(fihArray);
        int hashKeyItem = acb.addItem(hashKeyHolder);
        long conglomNumber = cd.getConglomerateNumber();
        StaticCompiledOpenConglomInfo scoci = this.getLanguageConnectionContext().getTransactionCompile().getStaticCompiledConglomInfo(conglomNumber);
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.push(conglomNumber);
        mb.push(acb.addItem(scoci));
        this.resultColumns.generateHolder(acb, mb, this.referencedCols, null);
        mb.push(this.getResultSetNumber());
        mb.push(hashKeyItem);
        mb.push(this.tableDescriptor.getName());
        if (this.tableProperties != null) {
            mb.push(org.apache.derby.iapi.util.PropertyUtil.sortProperties(this.tableProperties));
        } else {
            mb.pushNull("java.lang.String");
        }
        this.pushIndexName(cd, mb);
        mb.push(cd.isConstraint());
        mb.push(colRefItem);
        mb.push(this.getTrulyTheBestAccessPath().getLockMode());
        mb.push(tableLockGranularity);
        mb.push(this.getCompilerContext().getScanIsolationLevel());
        mb.push(costEstimate.singleScanRowCount());
        mb.push(costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getDistinctScanResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 16);
    }

    private void generateRefActionDependentTableScan(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        acb.pushGetResultSetFactoryExpression(mb);
        int nargs = this.getScanArguments(acb, mb);
        mb.push(this.raParentResultSetId);
        mb.push(this.fkIndexConglomId);
        mb.push(acb.addItem(this.fkColArray));
        mb.push(acb.addItem(this.getDataDictionary().getRowLocationTemplate(this.getLanguageConnectionContext(), this.tableDescriptor)));
        int argCount = nargs + 4;
        mb.callMethod((short)185, null, "getRaDependentTableScanResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", argCount);
        if (this.updateOrDelete == 1 || this.updateOrDelete == 2) {
            mb.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
            mb.putField(acb.getRowLocationScanResultSetName(), "org.apache.derby.iapi.sql.execute.CursorResultSet");
            mb.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        }
    }

    private int getScanArguments(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        AccessPath ap;
        JoinStrategy trulyTheBestJoinStrategy;
        ConglomerateDescriptor cd;
        MethodBuilder resultRowAllocator = this.resultColumns.generateHolderMethod(acb, this.referencedCols, null);
        int colRefItem = -1;
        if (this.referencedCols != null) {
            colRefItem = acb.addItem(this.referencedCols);
        }
        int indexColItem = -1;
        if ((this.cursorTargetTable || this.getUpdateLocks) && (cd = this.getTrulyTheBestAccessPath().getConglomerateDescriptor()).isIndex()) {
            int[] baseColPos = cd.getIndexDescriptor().baseColumnPositions();
            boolean[] isAscending = cd.getIndexDescriptor().isAscending();
            int[] indexCols = new int[baseColPos.length];
            for (int i = 0; i < indexCols.length; ++i) {
                indexCols[i] = isAscending[i] ? baseColPos[i] : -baseColPos[i];
            }
            indexColItem = acb.addItem(indexCols);
        }
        if (!(trulyTheBestJoinStrategy = (ap = this.getTrulyTheBestAccessPath()).getJoinStrategy()).bulkFetchOK() && this.bulkFetch != -1) {
            SanityManager.THROWASSERT("bulkFetch should not be set for the join strategy " + trulyTheBestJoinStrategy.getName());
        }
        int nargs = trulyTheBestJoinStrategy.getScanArgs(this.getLanguageConnectionContext().getTransactionCompile(), mb, this, this.storeRestrictionList, this.nonStoreRestrictionList, acb, this.bulkFetch, resultRowAllocator, colRefItem, indexColItem, this.getTrulyTheBestAccessPath().getLockMode(), this.tableDescriptor.getLockGranularity() == 'T', this.getCompilerContext().getScanIsolationLevel(), ap.getOptimizer().getMaxMemoryPerTable(), this.multiProbing);
        return nargs;
    }

    private int mapAbsoluteToRelativeColumnPosition(int absolutePosition) {
        if (this.referencedCols == null) {
            return absolutePosition;
        }
        int setBitCtr = 0;
        for (int bitCtr = 0; bitCtr < this.referencedCols.size() && bitCtr < absolutePosition; ++bitCtr) {
            if (!this.referencedCols.get(bitCtr)) continue;
            ++setBitCtr;
        }
        return setBitCtr;
    }

    public String getExposedName() {
        if (this.correlationName != null) {
            return this.correlationName;
        }
        return this.getOrigTableName().getFullTableName();
    }

    private TableName getExposedTableName() throws StandardException {
        if (this.correlationName != null) {
            return this.makeTableName(null, this.correlationName);
        }
        return this.getOrigTableName();
    }

    public TableName getTableNameField() {
        return this.tableName;
    }

    public ResultColumnList getAllResultColumns(TableName allTableName) throws StandardException {
        return this.getResultColumnsForList(allTableName, this.resultColumns, this.getOrigTableName());
    }

    public ResultColumnList genResultColList() throws StandardException {
        ResultColumnList rcList = null;
        ColumnDescriptor colDesc = null;
        TableName exposedName = this.getExposedTableName();
        rcList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ColumnDescriptorList cdl = this.tableDescriptor.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            colDesc = cdl.elementAt(index);
            colDesc.setTableDescriptor(this.tableDescriptor);
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, colDesc.getColumnName(), exposedName, colDesc.getType(), this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, colDesc, valueNode, this.getContextManager());
            rcList.addResultColumn(resultColumn);
        }
        return rcList;
    }

    public ResultColumnList addColsToList(ResultColumnList inputRcl, FormatableBitSet colsWeWant) throws StandardException {
        Object rcList = null;
        ColumnDescriptor cd = null;
        TableName exposedName = this.getExposedTableName();
        ResultColumnList newRcl = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ColumnDescriptorList cdl = this.tableDescriptor.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            cd = cdl.elementAt(index);
            int position = cd.getPosition();
            if (!colsWeWant.get(position)) continue;
            ResultColumn resultColumn = inputRcl.getResultColumn(position);
            if (resultColumn == null) {
                ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(62, cd.getColumnName(), exposedName, this.getContextManager());
                resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, cd, valueNode, this.getContextManager());
            }
            newRcl.addResultColumn(resultColumn);
        }
        return newRcl;
    }

    public TableName getTableName() throws StandardException {
        TableName tn = super.getTableName();
        if (tn != null && tn.getSchemaName() == null && this.correlationName == null) {
            tn.bind(this.getDataDictionary());
        }
        return tn != null ? tn : this.tableName;
    }

    public boolean markAsCursorTargetTable() {
        this.cursorTargetTable = true;
        return true;
    }

    protected boolean cursorTargetTable() {
        return this.cursorTargetTable;
    }

    void markUpdated(ResultColumnList updateColumns) {
        this.resultColumns.markUpdated(updateColumns);
    }

    public boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return baseTable && name.equals(this.getBaseTableName());
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.tableDescriptor.getSchemaDescriptor());
    }

    public boolean isOneRowResultSet() throws StandardException {
        if (this.existsBaseTable) {
            return true;
        }
        AccessPath ap = this.getTrulyTheBestAccessPath();
        JoinStrategy trulyTheBestJoinStrategy = ap.getJoinStrategy();
        if (trulyTheBestJoinStrategy.isHashJoin()) {
            PredicateList pl = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
            if (this.storeRestrictionList != null) {
                pl.nondestructiveAppend(this.storeRestrictionList);
            }
            if (this.nonStoreRestrictionList != null) {
                pl.nondestructiveAppend(this.nonStoreRestrictionList);
            }
            return this.isOneRowResultSet(pl);
        }
        return this.isOneRowResultSet(this.getTrulyTheBestAccessPath().getConglomerateDescriptor(), this.restrictionList);
    }

    public boolean isNotExists() {
        return this.isNotExists;
    }

    public boolean isOneRowResultSet(OptimizablePredicateList predList) throws StandardException {
        ConglomerateDescriptor[] cds = this.tableDescriptor.getConglomerateDescriptors();
        for (int index = 0; index < cds.length; ++index) {
            if (!this.isOneRowResultSet(cds[index], predList)) continue;
            return true;
        }
        return false;
    }

    protected boolean supersetOfUniqueIndex(boolean[] eqCols) throws StandardException {
        ConglomerateDescriptor[] cds = this.tableDescriptor.getConglomerateDescriptors();
        for (int index = 0; index < cds.length; ++index) {
            int inner;
            IndexRowGenerator id;
            ConglomerateDescriptor cd = cds[index];
            if (!cd.isIndex() || !(id = cd.getIndexDescriptor()).isUnique()) continue;
            int[] keyColumns = id.baseColumnPositions();
            for (inner = 0; inner < keyColumns.length && eqCols[keyColumns[inner]]; ++inner) {
            }
            if (inner != keyColumns.length) continue;
            return true;
        }
        return false;
    }

    protected boolean supersetOfUniqueIndex(JBitSet[] tableColMap) throws StandardException {
        ConglomerateDescriptor[] cds = this.tableDescriptor.getConglomerateDescriptors();
        for (int index = 0; index < cds.length; ++index) {
            IndexRowGenerator id;
            ConglomerateDescriptor cd = cds[index];
            if (!cd.isIndex() || !(id = cd.getIndexDescriptor()).isUnique()) continue;
            int[] keyColumns = id.baseColumnPositions();
            int numBits = tableColMap[0].size();
            JBitSet keyMap = new JBitSet(numBits);
            JBitSet resMap = new JBitSet(numBits);
            for (int inner = 0; inner < keyColumns.length; ++inner) {
                keyMap.set(keyColumns[inner]);
            }
            for (int table = 0; table < tableColMap.length; ++table) {
                resMap.setTo(tableColMap[table]);
                resMap.and(keyMap);
                if (!keyMap.equals(resMap)) continue;
                tableColMap[table].set(0);
                return true;
            }
        }
        return false;
    }

    public int updateTargetLockMode() {
        if (this.getTrulyTheBestAccessPath().getConglomerateDescriptor().isIndex()) {
            return 6;
        }
        int isolationLevel = this.getLanguageConnectionContext().getCurrentIsolationLevel();
        if (isolationLevel != 4 && this.tableDescriptor.getLockGranularity() != 'T') {
            int lockMode = this.getTrulyTheBestAccessPath().getLockMode();
            lockMode = lockMode != 6 ? (lockMode & 0xFF) << 16 : 0;
            return lockMode += 6;
        }
        return this.getTrulyTheBestAccessPath().getLockMode();
    }

    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, Vector fbtVector) throws StandardException {
        for (int index = 0; index < crs.length; ++index) {
            if (crs[index].getTableNumber() == this.tableNumber) continue;
            return false;
        }
        ConglomerateDescriptor cd = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        if (!cd.isIndex()) {
            return false;
        }
        boolean isOrdered = permuteOrdering ? this.isOrdered(crs, cd) : this.isStrictlyOrdered(crs, cd);
        if (fbtVector != null) {
            fbtVector.addElement(this);
        }
        return isOrdered;
    }

    void disableBulkFetch() {
        this.bulkFetchTurnedOff = true;
        this.bulkFetch = -1;
    }

    void doSpecialMaxScan() {
        if (this.restrictionList.size() != 0 || this.storeRestrictionList.size() != 0 || this.nonStoreRestrictionList.size() != 0) {
            SanityManager.THROWASSERT("shouldn't be setting max special scan because there is a restriction");
        }
        this.specialMaxScan = true;
    }

    boolean isPossibleDistinctScan(Set distinctColumns) {
        if (this.restrictionList != null && this.restrictionList.size() != 0) {
            return false;
        }
        HashSet<ValueNode> columns = new HashSet<ValueNode>();
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(i);
            columns.add(rc.getExpression());
        }
        return columns.equals(distinctColumns);
    }

    void markForDistinctScan() {
        this.distinctScan = true;
    }

    void adjustForSortElimination() {
    }

    void adjustForSortElimination(RequiredRowOrdering rowOrdering) throws StandardException {
        if (this.restrictionList != null) {
            this.restrictionList.adjustForSortElimination(rowOrdering);
        }
    }

    private boolean isOrdered(ColumnReference[] crs, ConglomerateDescriptor cd) throws StandardException {
        int nextCR;
        int nextKeyColumn;
        boolean[] matchedCRs = new boolean[crs.length];
        int[] keyColumns = cd.getIndexDescriptor().baseColumnPositions();
        for (nextKeyColumn = 0; nextKeyColumn < keyColumns.length; ++nextKeyColumn) {
            boolean currMatch = false;
            for (nextCR = 0; nextCR < crs.length; ++nextCR) {
                if (crs[nextCR].getColumnNumber() != keyColumns[nextKeyColumn]) continue;
                matchedCRs[nextCR] = true;
                currMatch = true;
                break;
            }
            if (!currMatch && !this.storeRestrictionList.hasOptimizableEqualityPredicate(this, keyColumns[nextKeyColumn], true)) break;
        }
        int numCRsMatched = 0;
        for (nextCR = 0; nextCR < matchedCRs.length; ++nextCR) {
            if (!matchedCRs[nextCR]) continue;
            ++numCRsMatched;
        }
        if (numCRsMatched == matchedCRs.length) {
            return true;
        }
        if (nextKeyColumn == keyColumns.length) {
            return cd.getIndexDescriptor().isUnique();
        }
        return false;
    }

    private boolean isStrictlyOrdered(ColumnReference[] crs, ConglomerateDescriptor cd) throws StandardException {
        int nextKeyColumn = 0;
        int[] keyColumns = cd.getIndexDescriptor().baseColumnPositions();
        block0: for (int nextCR = 0; nextCR < crs.length; ++nextCR) {
            if (nextKeyColumn == keyColumns.length) {
                if (cd.getIndexDescriptor().isUnique()) break;
                return false;
            }
            if (crs[nextCR].getColumnNumber() == keyColumns[nextKeyColumn]) {
                ++nextKeyColumn;
                continue;
            }
            while (crs[nextCR].getColumnNumber() != keyColumns[nextKeyColumn]) {
                if (!this.storeRestrictionList.hasOptimizableEqualityPredicate(this, keyColumns[nextKeyColumn], true)) {
                    return false;
                }
                if (++nextKeyColumn != keyColumns.length) continue;
                if (cd.getIndexDescriptor().isUnique()) continue block0;
                return false;
            }
        }
        return true;
    }

    private boolean isOneRowResultSet(ConglomerateDescriptor cd, OptimizablePredicateList predList) throws StandardException {
        if (predList == null) {
            return false;
        }
        if (!(predList instanceof PredicateList)) {
            SanityManager.THROWASSERT("predList should be a PredicateList, but is a " + predList.getClass().getName());
        }
        PredicateList restrictionList = (PredicateList)predList;
        if (!cd.isIndex()) {
            return false;
        }
        IndexRowGenerator irg = cd.getIndexDescriptor();
        if (!irg.isUnique()) {
            return false;
        }
        int[] baseColumnPositions = irg.baseColumnPositions();
        DataDictionary dd = this.getDataDictionary();
        for (int index = 0; index < baseColumnPositions.length; ++index) {
            int curCol = baseColumnPositions[index];
            if (restrictionList.hasOptimizableEqualityPredicate(this, curCol, true)) continue;
            return false;
        }
        return true;
    }

    private int getDefaultBulkFetch() throws StandardException {
        String valStr = PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.language.bulkFetchDefault", "16");
        int valInt = this.getIntProperty(valStr, "derby.language.bulkFetchDefault");
        if (valInt <= 0) {
            throw StandardException.newException("42Y64", String.valueOf(valInt));
        }
        return valInt <= 1 ? -1 : valInt;
    }

    private String getUserSpecifiedIndexName() {
        String retval = null;
        if (this.tableProperties != null) {
            retval = this.tableProperties.getProperty("index");
        }
        return retval;
    }

    private StoreCostController getStoreCostController(ConglomerateDescriptor cd) throws StandardException {
        return this.getCompilerContext().getStoreCostController(cd.getConglomerateNumber());
    }

    private StoreCostController getBaseCostController() throws StandardException {
        return this.getStoreCostController(this.baseConglomerateDescriptor);
    }

    private long baseRowCount() throws StandardException {
        if (!this.gotRowCount) {
            StoreCostController scc = this.getBaseCostController();
            this.rowCount = scc.getEstimatedRowCount();
            this.gotRowCount = true;
        }
        return this.rowCount;
    }

    private DataValueDescriptor[] getRowTemplate(ConglomerateDescriptor cd, StoreCostController scc) throws StandardException {
        if (!cd.isIndex()) {
            return this.templateColumns.buildEmptyRow().getRowArray();
        }
        ExecRow emptyIndexRow = this.templateColumns.buildEmptyIndexRow(this.tableDescriptor, cd, scc, this.getDataDictionary());
        return emptyIndexRow.getRowArray();
    }

    private ConglomerateDescriptor getFirstConglom() throws StandardException {
        this.getConglomDescs();
        return this.conglomDescs[0];
    }

    private ConglomerateDescriptor getNextConglom(ConglomerateDescriptor currCD) throws StandardException {
        int index;
        for (index = 0; index < this.conglomDescs.length && currCD != this.conglomDescs[index]; ++index) {
        }
        if (index < this.conglomDescs.length - 1) {
            return this.conglomDescs[index + 1];
        }
        return null;
    }

    private void getConglomDescs() throws StandardException {
        if (this.conglomDescs == null) {
            this.conglomDescs = this.tableDescriptor.getConglomerateDescriptors();
        }
    }

    public void setRefActionInfo(long fkIndexConglomId, int[] fkColArray, String parentResultSetId, boolean dependentScan) {
        this.fkIndexConglomId = fkIndexConglomId;
        this.fkColArray = fkColArray;
        this.raParentResultSetId = parentResultSetId;
        this.raDependentScan = dependentScan;
    }

    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = super.accept(v);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.nonStoreRestrictionList != null && !v.stopTraversal()) {
            this.nonStoreRestrictionList.accept(v);
        }
        if (this.restrictionList != null & !v.stopTraversal()) {
            this.restrictionList.accept(v);
        }
        if (this.nonBaseTableRestrictionList != null && !v.stopTraversal()) {
            this.nonBaseTableRestrictionList.accept(v);
        }
        if (this.requalificationRestrictionList != null && !v.stopTraversal()) {
            this.requalificationRestrictionList.accept(v);
        }
        return returnNode;
    }
}

