/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.UnaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class IsNullNode
extends UnaryComparisonOperatorNode
implements RelationalOperator {
    private DataValueDescriptor nullValue;

    public void setNodeType(int nodeType) {
        String methodName;
        String operator;
        if (nodeType == 25) {
            operator = "is null";
            methodName = "isNullOp";
        } else {
            if (nodeType != 24) {
                SanityManager.THROWASSERT("Unexpected nodeType = " + nodeType);
            }
            operator = "is not null";
            methodName = "isNotNull";
        }
        this.setOperator(operator);
        this.setMethodName(methodName);
        super.setNodeType(nodeType);
    }

    UnaryOperatorNode getNegation(ValueNode operand) throws StandardException {
        SanityManager.ASSERT(this.getTypeServices() != null, "dataTypeServices is expected to be non-null");
        if (this.isNullNode()) {
            this.setNodeType(24);
        } else {
            if (!this.isNotNullNode()) {
                SanityManager.THROWASSERT("Unexpected nodeType = " + this.getNodeType());
            }
            this.setNodeType(25);
        }
        return this;
    }

    void bindParameter() throws StandardException {
        this.operand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
    }

    public boolean usefulStartKey(Optimizable optTable) {
        return this.isNullNode();
    }

    public boolean usefulStopKey(Optimizable optTable) {
        return this.isNullNode();
    }

    public int getStartOperator(Optimizable optTable) {
        if (!this.isNullNode()) {
            SanityManager.THROWASSERT("getNodeType() not expected to return " + this.getNodeType());
        }
        return 1;
    }

    public int getStopOperator(Optimizable optTable) {
        if (!this.isNullNode()) {
            SanityManager.THROWASSERT("getNodeType() not expected to return " + this.getNodeType());
        }
        return -1;
    }

    public void generateOperator(MethodBuilder mb, Optimizable optTable) {
        mb.push(2);
    }

    public void generateNegate(MethodBuilder mb, Optimizable optTable) {
        mb.push(this.isNotNullNode());
    }

    public int getOperator() {
        int operator;
        if (this.isNullNode()) {
            operator = 7;
        } else {
            if (!this.isNotNullNode()) {
                SanityManager.THROWASSERT("Unexpected nodeType = " + this.getNodeType());
            }
            operator = 8;
        }
        return operator;
    }

    public boolean compareWithKnownConstant(Optimizable optTable, boolean considerParameters) {
        return true;
    }

    public DataValueDescriptor getCompareValue(Optimizable optTable) throws StandardException {
        if (this.nullValue == null) {
            this.nullValue = this.operand.getTypeServices().getNull();
        }
        return this.nullValue;
    }

    public boolean equalsComparisonWithConstantExpression(Optimizable optTable) {
        boolean retval = false;
        if (this.isNotNullNode()) {
            return false;
        }
        if (this.operand instanceof ColumnReference) {
            int tabNum = ((ColumnReference)this.operand).getTableNumber();
            if (optTable.hasTableNumber() && optTable.getTableNumber() == tabNum) {
                retval = true;
            }
        }
        return retval;
    }

    public RelationalOperator getTransitiveSearchClause(ColumnReference otherCR) throws StandardException {
        return (RelationalOperator)((Object)this.getNodeFactory().getNode(this.getNodeType(), otherCR, this.getContextManager()));
    }

    public String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.DataValueDescriptor";
    }

    public double selectivity(Optimizable optTable) {
        if (this.isNullNode()) {
            return 0.1;
        }
        if (!this.isNotNullNode()) {
            SanityManager.THROWASSERT("Unexpected nodeType = " + this.getNodeType());
        }
        return 0.9;
    }

    private boolean isNullNode() {
        return this.getNodeType() == 25;
    }

    private boolean isNotNullNode() {
        return this.getNodeType() == 24;
    }

    public boolean isRelationalOperator() {
        return true;
    }

    public boolean optimizableEqualityNode(Optimizable optTable, int columnNumber, boolean isNullOkay) {
        if (!this.isNullNode() || !isNullOkay) {
            return false;
        }
        ColumnReference cr = this.getColumnOperand(optTable, columnNumber);
        return cr != null;
    }
}

