/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class RowResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public int rowsReturned;
    private boolean canCacheRow;
    private boolean next;
    private GeneratedMethod row;
    private ExecRow cachedRow;

    RowResultSet(Activation activation, GeneratedMethod row, boolean canCacheRow, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.row = row;
        this.canCacheRow = canCacheRow;
        this.recordConstructorTime();
    }

    RowResultSet(Activation activation, ExecRow constantRow, boolean canCacheRow, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.beginTime = this.getCurrentTimeMillis();
        this.cachedRow = constantRow;
        this.canCacheRow = canCacheRow;
        this.recordConstructorTime();
    }

    public void openCore() throws StandardException {
        this.next = false;
        this.beginTime = this.getCurrentTimeMillis();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        this.currentRow = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            if (!this.next) {
                this.next = true;
                if (this.cachedRow != null) {
                    this.currentRow = this.cachedRow;
                } else if (this.row != null) {
                    this.currentRow = (ExecRow)this.row.invoke(this.activation);
                    if (this.canCacheRow) {
                        this.cachedRow = this.currentRow;
                    }
                }
                ++this.rowsReturned;
            }
            this.setCurrentRow(this.currentRow);
            this.nextTime += this.getElapsedMillis(this.beginTime);
        }
        return this.currentRow;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.next = false;
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of RowResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        return totTime;
    }

    public RowLocation getRowLocation() {
        SanityManager.THROWASSERT("RowResultSet used in positioned update/delete");
        return null;
    }

    public ExecRow getCurrentRow() {
        SanityManager.THROWASSERT("RowResultSet used in positioned update/delete");
        return null;
    }
}

