/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.ResultSetStatistics;

public class RealUnionResultSetStatistics
extends RealNoPutResultSetStatistics {
    public int rowsSeenLeft;
    public int rowsSeenRight;
    public int rowsReturned;
    public ResultSetStatistics leftResultSetStatistics;
    public ResultSetStatistics rightResultSetStatistics;

    public RealUnionResultSetStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, int rowsSeenLeft, int rowsSeenRight, int rowsReturned, double optimizerEstimatedRowCount, double optimizerEstimatedCost, ResultSetStatistics leftResultSetStatistics, ResultSetStatistics rightResultSetStatistics) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.rowsSeenLeft = rowsSeenLeft;
        this.rowsSeenRight = rowsSeenRight;
        this.rowsReturned = rowsReturned;
        this.leftResultSetStatistics = leftResultSetStatistics;
        this.rightResultSetStatistics = rightResultSetStatistics;
    }

    public String getStatementExecutionPlanText(int depth) {
        this.initFormatInfo(depth);
        return this.indent + MessageService.getTextMessage("43Y14.U") + ":\n" + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X79.U") + " = " + this.rowsSeenLeft + "\n" + this.indent + MessageService.getTextMessage("43X80.U") + " = " + this.rowsSeenRight + "\n" + this.indent + MessageService.getTextMessage("43X81.U") + " = " + this.rowsReturned + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X82.U") + ":\n" + this.leftResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n" + this.indent + MessageService.getTextMessage("43X83.U") + ":\n" + this.rightResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    public String getScanStatisticsText(String tableName, int depth) {
        return this.leftResultSetStatistics.getScanStatisticsText(tableName, depth) + this.rightResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public Vector getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.leftResultSetStatistics);
        children.addElement(this.rightResultSetStatistics);
        return children;
    }

    public String getNodeName() {
        return MessageService.getTextMessage("43Y15.U");
    }
}

