/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;

public final class ConglomerateUtil {
    public static Properties createRawStorePropertySet(Properties prop) {
        prop = ConglomerateUtil.createUserRawStorePropertySet(prop);
        prop.put("derby.storage.reusableRecordId", "");
        return prop;
    }

    public static Properties createUserRawStorePropertySet(Properties prop) {
        if (prop == null) {
            prop = new Properties();
        }
        prop.put("derby.storage.pageSize", "");
        prop.put("derby.storage.minimumRecordSize", "");
        prop.put("derby.storage.pageReservedSpace", "");
        prop.put("derby.storage.initialPages", "");
        return prop;
    }

    public static int[] createFormatIds(DataValueDescriptor[] template) {
        int[] format_ids = new int[template.length];
        for (int i = 0; i < template.length; ++i) {
            if (template[i] == null) {
                SanityManager.THROWASSERT("row template is null for column[" + i + "].");
            }
            if (!(template[i] instanceof Formatable)) {
                SanityManager.THROWASSERT("row template is not formatable column[" + i + "].  Type is " + template[i].getClass().getName());
            }
            format_ids[i] = template[i].getTypeFormatId();
        }
        return format_ids;
    }

    public static int[] readFormatIdArray(int num, ObjectInput in) throws IOException {
        int[] format_ids = new int[num];
        for (int i = 0; i < num; ++i) {
            format_ids[i] = FormatIdUtil.readFormatIdInteger(in);
        }
        return format_ids;
    }

    public static void writeFormatIdArray(int[] format_id_array, ObjectOutput out) throws IOException {
        for (int i = 0; i < format_id_array.length; ++i) {
            FormatIdUtil.writeFormatIdInteger(out, format_id_array[i]);
        }
    }

    public static int[] createCollationIds(int sizeof_ids, int[] collationIds) {
        int[] collation_ids = new int[sizeof_ids];
        if (collationIds != null) {
            if (sizeof_ids != collationIds.length) {
                SanityManager.THROWASSERT("sizeof_ids = " + sizeof_ids + ";collationIds.length = " + collationIds.length);
            }
            System.arraycopy(collationIds, 0, collation_ids, 0, collationIds.length);
        } else {
            for (int i = 0; i < collation_ids.length; ++i) {
                collation_ids[i] = 0;
            }
        }
        return collation_ids;
    }

    public static void writeCollationIdArray(int[] collation_id_array, ObjectOutput out) throws IOException {
        int i;
        int non_collate_val_count = 0;
        for (i = 0; i < collation_id_array.length; ++i) {
            if (collation_id_array[i] == 0) continue;
            ++non_collate_val_count;
        }
        CompressedNumber.writeInt(out, non_collate_val_count);
        for (i = 0; i < collation_id_array.length; ++i) {
            if (collation_id_array[i] == 0) continue;
            CompressedNumber.writeInt(out, i);
            CompressedNumber.writeInt(out, collation_id_array[i]);
        }
    }

    public static void readCollationIdArray(int[] collation_id_array, ObjectInput in) throws IOException {
        int num_compressed_entries = CompressedNumber.readInt(in);
        for (int i = 0; i < num_compressed_entries; ++i) {
            int array_index = CompressedNumber.readInt(in);
            collation_id_array[array_index] = CompressedNumber.readInt(in);
        }
    }

    public static String debugPage(Page page, int start_slot, boolean full_rh, DataValueDescriptor[] template) {
        StringBuffer string = new StringBuffer(4096);
        string.append("PAGE:(");
        string.append(page.getPageNumber());
        string.append(")------------------------------------------:\n");
        try {
            if (page != null) {
                int numrows = page.recordCount();
                for (int slot_no = start_slot; slot_no < numrows; ++slot_no) {
                    RecordHandle rh = page.fetchFromSlot(null, slot_no, template, null, true);
                    string.append(page.isDeletedAtSlot(slot_no) ? "D:" : " :");
                    string.append("row[");
                    string.append(slot_no);
                    string.append("](id:");
                    string.append(rh.getId());
                    string.append("):\t");
                    if (full_rh) {
                        string.append("[");
                        string.append(rh.toString());
                        string.append("]:");
                    }
                    string.append(RowUtil.toString(template));
                    string.append("\n");
                }
            }
        }
        catch (Throwable t) {
            string.append("Error encountered while building string");
        }
        return string.toString();
    }
}

