/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.SpaceInfo;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;
import org.apache.derby.impl.store.access.conglomerate.OpenConglomerateScratchSpace;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;

public abstract class OpenConglomerate {
    private Conglomerate init_conglomerate;
    private TransactionManager init_xact_manager;
    private Transaction init_rawtran;
    private int init_openmode;
    private int init_lock_level;
    private DynamicCompiledOpenConglomInfo init_dynamic_info;
    private boolean init_hold;
    private LockingPolicy init_locking_policy;
    private boolean useUpdateLocks;
    private boolean forUpdate;
    private boolean getBaseTableLocks;
    private OpenConglomerateScratchSpace runtime_mem;
    private ContainerHandle container;

    protected abstract RowLocation newRowLocationTemplate() throws StandardException;

    public abstract int[] getFormatIds();

    public boolean latchPageAndRepositionScan(RowPosition pos) throws StandardException {
        boolean scan_repositioned = false;
        pos.current_page = null;
        try {
            if (pos.current_rh != null) {
                pos.current_page = this.container.getPage(pos.current_rh.getPageNumber());
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (pos.current_page != null) {
            try {
                pos.current_slot = pos.current_page.getSlotNumber(pos.current_rh);
            }
            catch (StandardException se) {
                scan_repositioned = true;
                pos.current_slot = pos.current_page.getNextSlotNumber(pos.current_rh);
                if (pos.current_slot == -1) {
                    pos.current_page.unlatch();
                    pos.current_page = null;
                }
                --pos.current_slot;
            }
        }
        if (pos.current_page == null) {
            long current_pageno;
            if (pos.current_rh != null) {
                current_pageno = pos.current_rh.getPageNumber();
            } else if (pos.current_pageno != -1L) {
                current_pageno = pos.current_pageno;
            } else {
                return false;
            }
            pos.current_page = this.container.getNextPage(current_pageno);
            pos.current_slot = -1;
            pos.current_pageno = -1L;
            scan_repositioned = true;
        }
        if (scan_repositioned) {
            pos.current_rh = null;
        }
        return scan_repositioned;
    }

    public boolean latchPage(RowPosition pos) throws StandardException {
        pos.current_page = null;
        try {
            pos.current_page = this.container.getPage(pos.current_rh.getPageNumber());
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (pos.current_page != null) {
            try {
                pos.current_slot = pos.current_page.getSlotNumber(pos.current_rh);
                return true;
            }
            catch (Throwable t) {
                pos.current_page.unlatch();
                pos.current_page = null;
            }
        }
        return false;
    }

    public boolean lockPositionForRead(RowPosition pos, RowPosition aux_pos, boolean moveForwardIfRowDisappears, boolean waitForLock) throws StandardException {
        if (pos.current_rh == null) {
            SanityManager.ASSERT(pos.current_page != null && pos.current_slot != -1);
            pos.current_rh = pos.current_page.getRecordHandleAtSlot(pos.current_slot);
            if (pos.current_slot != pos.current_page.getSlotNumber(pos.current_rh)) {
                SanityManager.THROWASSERT("current_slot = " + pos.current_slot + "current_rh = " + pos.current_rh + "current_rh.slot = " + pos.current_page.getSlotNumber(pos.current_rh));
            }
        }
        SanityManager.ASSERT(pos.current_rh != null);
        boolean lock_granted_with_latch_held = this.container.getLockingPolicy().lockRecordForRead(this.init_rawtran, this.container, pos.current_rh, false, this.forUpdate);
        if (!lock_granted_with_latch_held) {
            pos.current_page.unlatch();
            pos.current_page = null;
            if (aux_pos != null) {
                aux_pos.current_page.unlatch();
                aux_pos.current_page = null;
            }
            if (!waitForLock) {
                throw StandardException.newException("40XL1");
            }
            this.container.getLockingPolicy().lockRecordForRead(this.init_rawtran, this.container, pos.current_rh, true, this.forUpdate);
            if (moveForwardIfRowDisappears) {
                if (this.latchPageAndRepositionScan(pos) && pos.current_slot != -1) {
                    pos.positionAtNextSlot();
                    this.lockPositionForRead(pos, aux_pos, true, true);
                }
            } else {
                this.latchPage(pos);
            }
        }
        return lock_granted_with_latch_held;
    }

    public boolean lockPositionForWrite(RowPosition pos, boolean forInsert, boolean waitForLock) throws StandardException {
        if (pos.current_rh == null) {
            SanityManager.ASSERT(pos.current_page != null);
            SanityManager.ASSERT(pos.current_slot != -1);
            pos.current_rh = pos.current_page.fetchFromSlot(null, pos.current_slot, RowUtil.EMPTY_ROW, RowUtil.EMPTY_ROW_FETCH_DESCRIPTOR, true);
            if (pos.current_slot != pos.current_page.getSlotNumber(pos.current_rh)) {
                SanityManager.THROWASSERT("current_slot = " + pos.current_slot + "current_rh = " + pos.current_rh + "current_rh.slot = " + pos.current_page.getSlotNumber(pos.current_rh));
            }
        }
        SanityManager.ASSERT(pos.current_rh != null);
        boolean lock_granted_with_latch_held = this.container.getLockingPolicy().lockRecordForWrite(this.init_rawtran, pos.current_rh, forInsert, false);
        if (!lock_granted_with_latch_held) {
            if (!waitForLock) {
                throw StandardException.newException("40XL1");
            }
            pos.current_page.unlatch();
            pos.current_page = null;
            if (!waitForLock) {
                throw StandardException.newException("40XL1");
            }
            this.container.getLockingPolicy().lockRecordForWrite(this.init_rawtran, pos.current_rh, forInsert, true);
            this.latchPage(pos);
        }
        return lock_granted_with_latch_held;
    }

    public void unlockPositionAfterRead(RowPosition pos) throws StandardException {
        if (!this.isClosed()) {
            this.container.getLockingPolicy().unlockRecordAfterRead(this.init_rawtran, this.container, pos.current_rh, this.forUpdate, pos.current_rh_qualified);
        }
    }

    public Properties getInternalTablePropertySet(Properties prop) throws StandardException {
        Properties ret_properties = ConglomerateUtil.createRawStorePropertySet(prop);
        this.getTableProperties(ret_properties);
        return ret_properties;
    }

    public void getTableProperties(Properties prop) throws StandardException {
        this.container.getContainerProperties(prop);
    }

    public final TransactionManager getXactMgr() {
        return this.init_xact_manager;
    }

    public final Transaction getRawTran() {
        return this.init_rawtran;
    }

    public final ContainerHandle getContainer() {
        return this.container;
    }

    public final int getOpenMode() {
        return this.init_openmode;
    }

    public final Conglomerate getConglomerate() {
        return this.init_conglomerate;
    }

    public final boolean getHold() {
        return this.init_hold;
    }

    public final boolean isForUpdate() {
        return this.forUpdate;
    }

    public final boolean isClosed() {
        return this.container == null;
    }

    public final boolean isUseUpdateLocks() {
        return this.useUpdateLocks;
    }

    public final OpenConglomerateScratchSpace getRuntimeMem() {
        return this.runtime_mem;
    }

    public void checkConsistency() throws StandardException {
    }

    public void debugConglomerate() throws StandardException {
        SanityManager.DEBUG_PRINT("p_heap", "\nHEAP DUMP:containerId " + this.container.getId());
        DataValueDescriptor[] row = this.runtime_mem.get_row_for_export(this.getRawTran());
        Page page = this.container.getFirstPage();
        while (page != null) {
            SanityManager.DEBUG_PRINT("p_heap", ConglomerateUtil.debugPage(page, 0, false, row));
            long pageid = page.getPageNumber();
            page.unlatch();
            page = this.container.getNextPage(pageid);
        }
    }

    public SpaceInfo getSpaceInfo() throws StandardException {
        return this.container.getSpaceInfo();
    }

    protected boolean isKeyed() {
        return false;
    }

    protected boolean isTableLocked() {
        return this.init_lock_level == 7;
    }

    public ContainerHandle init(ContainerHandle open_container, Conglomerate conglomerate, int[] format_ids, int[] collation_ids, TransactionManager xact_manager, Transaction rawtran, boolean hold, int openmode, int lock_level, LockingPolicy locking_policy, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        this.init_conglomerate = conglomerate;
        this.init_xact_manager = xact_manager;
        this.init_rawtran = rawtran;
        this.init_openmode = openmode;
        this.init_lock_level = lock_level;
        this.init_dynamic_info = dynamic_info;
        this.init_hold = hold;
        this.init_locking_policy = locking_policy;
        this.runtime_mem = dynamic_info != null ? (OpenConglomerateScratchSpace)dynamic_info : new OpenConglomerateScratchSpace(format_ids, collation_ids);
        this.forUpdate = (openmode & 4) != 0;
        this.useUpdateLocks = (openmode & 0x1000) != 0;
        boolean bl = this.getBaseTableLocks = (openmode & 0x2000) == 0;
        if (conglomerate.isTemporary()) {
            this.init_openmode |= 0x800;
        }
        if (!this.getBaseTableLocks) {
            this.init_locking_policy = null;
        }
        this.container = open_container != null ? open_container : rawtran.openContainer(conglomerate.getId(), this.init_locking_policy, this.init_openmode);
        return this.container;
    }

    public ContainerHandle reopen() throws StandardException {
        if (this.container == null) {
            this.container = this.init_rawtran.openContainer(this.init_conglomerate.getId(), this.init_locking_policy, this.init_openmode);
        }
        return this.container;
    }

    public void close() throws StandardException {
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
    }
}

