/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.jdbc.JDBCBoot;
import org.apache.derby.jdbc.AutoloadedDriver;

public class EmbeddedDriver
implements Driver {
    private AutoloadedDriver _autoloadedDriver;

    public EmbeddedDriver() {
        EmbeddedDriver.boot();
    }

    public boolean acceptsURL(String url) throws SQLException {
        return this.getDriverModule().acceptsURL(url);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        return this.getDriverModule().connect(url, info);
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.getDriverModule().getPropertyInfo(url, info);
    }

    public int getMajorVersion() {
        try {
            return this.getDriverModule().getMajorVersion();
        }
        catch (SQLException se) {
            return 0;
        }
    }

    public int getMinorVersion() {
        try {
            return this.getDriverModule().getMinorVersion();
        }
        catch (SQLException se) {
            return 0;
        }
    }

    public boolean jdbcCompliant() {
        try {
            return this.getDriverModule().jdbcCompliant();
        }
        catch (SQLException se) {
            return false;
        }
    }

    private Driver getDriverModule() throws SQLException {
        return AutoloadedDriver.getDriverModule();
    }

    static void boot() {
        PrintStream ps = DriverManager.getLogStream();
        if (ps == null) {
            ps = System.err;
        }
        new JDBCBoot().boot("jdbc:derby:", ps);
    }

    static {
        EmbeddedDriver.boot();
    }
}

