/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.dataextraction.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IDataExtractionOption;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.dataextraction.CSVDataExtractionOption;
import org.eclipse.birt.report.engine.dataextraction.ICSVDataExtractionOption;
import org.eclipse.birt.report.engine.dataextraction.csv.CSVUtil;
import org.eclipse.birt.report.engine.dataextraction.i18n.Messages;
import org.eclipse.birt.report.engine.dataextraction.impl.CommonDataExtractionImpl;

public class CSVDataExtractionImpl
extends CommonDataExtractionImpl {
    public static final String PLUGIN_ID = "org.eclipse.birt.report.engine.dataextraction.csv";
    public static final String DEFAULT_ENCODING = Charset.defaultCharset().name();
    private OutputStream outputStream;
    private String encoding;
    private String sep;
    private boolean isExportDataType;
    private String[] selectedColumnNames;

    public void initialize(IReportContext context, IDataExtractionOption options) throws BirtException {
        super.initialize(context, options);
        this.initCsvOptions(options);
    }

    private void initCsvOptions(IDataExtractionOption options) {
        this.outputStream = options.getOutputStream();
        Object csvOptions = options instanceof ICSVDataExtractionOption ? (ICSVDataExtractionOption)options : new CSVDataExtractionOption(options.getOptions());
        this.encoding = csvOptions.getEncoding();
        this.encoding = this.encoding == null || "".equals(this.encoding.trim()) ? null : this.encoding.trim();
        if (this.encoding == null) {
            this.encoding = DEFAULT_ENCODING;
        }
        this.sep = csvOptions.getSeparator();
        if (this.sep == null || "".equals(this.sep)) {
            this.sep = ",";
        }
        this.isExportDataType = csvOptions.isExportDataType();
        this.selectedColumnNames = csvOptions.getSelectedColumns();
    }

    public void output(IExtractionResults results) throws BirtException {
        try {
            String[] columnNames = this.selectedColumnNames;
            if (this.selectedColumnNames == null || this.selectedColumnNames.length <= 0) {
                int count = results.getResultMetaData().getColumnCount();
                columnNames = new String[count];
                int i = 0;
                while (i < count) {
                    String colName;
                    columnNames[i] = colName = results.getResultMetaData().getColumnName(i);
                    ++i;
                }
            }
            IDataIterator iData = null;
            if (results != null && (iData = results.nextResultIterator()) != null && columnNames.length > 0) {
                this.output(CSVUtil.makeCSVRow(columnNames, this.sep));
                int[] columnTypes = this.getColumnTypes(columnNames, results);
                if (this.isExportDataType) {
                    this.output(this.makeDataTypesRow(columnTypes));
                }
                String[] values = new String[columnNames.length];
                while (iData.next()) {
                    int i = 0;
                    while (i < columnNames.length) {
                        values[i] = columnTypes[i] != 7 && columnTypes[i] != 8 ? this.getStringValue(iData.getValue(columnNames[i])) : null;
                        ++i;
                    }
                    this.output(CSVUtil.makeCSVRow(values, this.sep));
                }
            }
        }
        catch (Exception e) {
            throw new BirtException(PLUGIN_ID, Messages.getString((String)"exception.dataextraction.exception_occured"), null, (Throwable)e);
        }
    }

    private String makeDataTypesRow(int[] types) {
        String[] values = new String[types.length];
        int i = 0;
        while (i < types.length) {
            values[i] = DataType.getName((int)types[i]);
            ++i;
        }
        return CSVUtil.makeCSVRow(values, this.sep);
    }

    private int[] getColumnTypes(String[] columnNames, IExtractionResults results) throws BirtException {
        HashMap<String, Integer> typesMap = new HashMap<String, Integer>();
        int count = results.getResultMetaData().getColumnCount();
        int i = 0;
        while (i < count) {
            String colName = results.getResultMetaData().getColumnName(i);
            int colType = results.getResultMetaData().getColumnType(i);
            typesMap.put(colName, colType);
            ++i;
        }
        int[] types = new int[columnNames.length];
        int i2 = 0;
        while (i2 < columnNames.length) {
            types[i2] = (Integer)typesMap.get(columnNames[i2]);
            ++i2;
        }
        return types;
    }

    private void output(String s) throws IOException, UnsupportedEncodingException {
        this.outputStream.write(s.getBytes(this.encoding));
    }
}

