/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.css.StyleSheetParserException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.css.CssParser;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssUtil;
import org.eclipse.birt.report.model.css.StyleRule;
import org.eclipse.birt.report.model.css.StyleSheet;
import org.eclipse.birt.report.model.css.property.ParseException;
import org.eclipse.birt.report.model.css.property.PropertyParser;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.CssPropertyUtil;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.flute.parser.selectors.ClassConditionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StyleSheetLoader {
    private CssParser parser;
    private Module module = null;
    private Reader source = null;
    private final IElementDefn style = MetaDataDictionary.getInstance().getStyle();
    private List<StyleSheetParserException> warnings = null;
    private static Logger logger = Logger.getLogger(StyleSheetLoader.class.getName());

    public StyleSheetLoader() {
        this.parser = new CssParser();
        this.warnings = new ArrayList<StyleSheetParserException>();
    }

    public void Reinit() {
        this.parser = new CssParser();
        this.module = null;
        this.source = null;
        this.warnings = new ArrayList<StyleSheetParserException>();
    }

    public CssStyleSheet load(Module module, URL url, String spec) throws StyleSheetException {
        if (url == null) {
            throw new StyleSheetException("Error.StyleSheetException.STYLE_SHEET_NOT_FOUND");
        }
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            throw new StyleSheetException("Error.StyleSheetException.STYLE_SHEET_NOT_FOUND", e);
        }
        CssStyleSheet sheet = this.load(module, is);
        sheet.setFileName(spec);
        return sheet;
    }

    public CssStyleSheet load(Module module, String spec) throws StyleSheetException {
        assert (module != null);
        this.module = module;
        URL url = module.findResource(spec, 3);
        CssStyleSheet retSheet = this.load(module, url, spec);
        return retSheet;
    }

    public CssStyleSheet load(Module module, InputStream is) throws StyleSheetException {
        assert (module != null);
        this.module = module;
        if (is == null) {
            throw new StyleSheetException("Error.StyleSheetException.STYLE_SHEET_NOT_FOUND");
        }
        this.source = new InputStreamReader(is);
        return this.load(this.source);
    }

    CssStyleSheet load(Reader charStream) throws StyleSheetException {
        StyleSheet ss = null;
        try {
            try {
                InputSource is = new InputSource(this.source);
                ss = (StyleSheet)this.parser.parseStyleSheet(is);
            }
            catch (CSSException e) {
                logger.log(Level.SEVERE, e.getMessage());
                throw new StyleSheetException("Error.StyleSheetException.SYNTAX_ERROR", e);
            }
            catch (IOException e) {
                throw new StyleSheetException("Error.StyleSheetException.STYLE_SHEET_NOT_FOUND", e);
            }
        }
        catch (Throwable throwable) {
            try {
                this.source.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            this.source.close();
        }
        catch (IOException iOException) {}
        if (ss == null) {
            return null;
        }
        CssStyleSheet styleSheet = new CssStyleSheet();
        List<CSSRule> rules = ss.getRules();
        int i = 0;
        while (i < rules.size()) {
            CSSRule rule = rules.get(i);
            this.loadStyle(styleSheet, rule);
            ++i;
        }
        styleSheet.addWarning(this.warnings);
        styleSheet.setErrorHandler(this.parser.getErrorHandler());
        return styleSheet;
    }

    void loadStyle(CssStyleSheet styleSheet, CSSRule rule) throws StyleSheetException {
        if (rule.getType() == 1) {
            try {
                StyleRule sr = (StyleRule)rule;
                SelectorList selectionList = sr.getSelectorList();
                CSSStyleDeclaration declaration = sr.getStyle();
                LinkedHashMap<String, ? extends Object> properties = null;
                ArrayList<StyleSheetParserException> errors = new ArrayList<StyleSheetParserException>();
                boolean buildProperties = false;
                int i = 0;
                while (i < selectionList.getLength()) {
                    Selector selector = selectionList.item(i);
                    short type = selector.getSelectorType();
                    String name = null;
                    boolean isValid = false;
                    switch (type) {
                        case 0: {
                            SimpleSelector simple = ((ConditionalSelector)selector).getSimpleSelector();
                            Condition condition = ((ConditionalSelector)selector).getCondition();
                            if ((simple instanceof ElementSelector || simple == null) && (simple == null || ((ElementSelector)simple).getLocalName() == null || ((ElementSelector)simple).getLocalName().equalsIgnoreCase("*")) && condition.getConditionType() == 9) {
                                name = ((ClassConditionImpl)condition).getValue();
                                isValid = true;
                            }
                            if (isValid) break;
                            StyleSheetParserException exception = new StyleSheetParserException(CssUtil.toString(selector), "Error.StyleSheetParserException.STYLE_NOT_SUPPORTED");
                            this.semanticWarning(exception);
                            styleSheet.addUnsupportedStyle(CssUtil.toString(selector).toLowerCase(), exception);
                            name = null;
                            break;
                        }
                        default: {
                            StyleSheetParserException exception = new StyleSheetParserException(CssUtil.toString(selector), "Error.StyleSheetParserException.STYLE_NOT_SUPPORTED");
                            this.semanticWarning(exception);
                            styleSheet.addUnsupportedStyle(CssUtil.toString(selector).toLowerCase(), exception);
                            name = null;
                        }
                    }
                    if (name != null) {
                        StyleElement style = styleSheet.findStyle(name);
                        if (style == null) {
                            style = new CssStyle(name);
                        } else {
                            styleSheet.removeStyle(name);
                        }
                        if (!buildProperties) {
                            properties = this.buildProperties(declaration, errors);
                            buildProperties = true;
                        }
                        this.addProperties(style, properties);
                        assert (styleSheet.findStyle(name) == null);
                        List<StyleSheetParserException> ret = styleSheet.getWarnings(name);
                        if (ret == null) {
                            ArrayList<StyleSheetParserException> localErrors = new ArrayList<StyleSheetParserException>();
                            localErrors.addAll(errors);
                            styleSheet.addWarnings(name, localErrors);
                        } else {
                            ret.addAll(errors);
                        }
                        styleSheet.addStyle(style);
                    }
                    ++i;
                }
            }
            catch (CSSException e) {
                logger.log(Level.SEVERE, e.getMessage());
                throw new StyleSheetException("Error.StyleSheetException.SYNTAX_ERROR", e);
            }
        } else {
            this.semanticWarning(new StyleSheetParserException(rule.toString(), "Error.StyleSheetParserException.RULE_NOT_SUPPORTED"));
        }
    }

    LinkedHashMap<String, ? extends Object> buildProperties(CSSStyleDeclaration declaration, List<StyleSheetParserException> errors) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < declaration.getLength()) {
            String cssName = declaration.item(i);
            String cssValue = declaration.getPropertyValue(cssName);
            if (!StringUtil.isBlank(cssName) && !StringUtil.isBlank(cssValue)) {
                properties.put(cssName, cssValue);
            }
            ++i;
        }
        return this.buildProperties(properties, errors);
    }

    LinkedHashMap<String, ? extends Object> buildProperties(LinkedHashMap<String, String> cssProperties, List<StyleSheetParserException> errors) {
        if (cssProperties.isEmpty()) {
            return cssProperties;
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> entry : cssProperties.entrySet()) {
            StyleSheetParserException exception;
            String cssName = entry.getKey();
            String cssValue = entry.getValue();
            assert (!StringUtil.isBlank(cssName));
            assert (!StringUtil.isBlank(cssValue));
            cssName = cssName.toLowerCase();
            try {
                StyleSheetParserException exception2;
                LinkedHashMap<String, String> shortHand;
                PropertyParser parser;
                List<StyleSheetParserException> ret;
                if (cssName.equalsIgnoreCase("background-position")) {
                    ret = this.handleBackgroundPosition(cssValue, properties);
                    if (ret.isEmpty()) continue;
                    errors.addAll(ret);
                    continue;
                }
                if (cssName.equalsIgnoreCase("background-size")) {
                    ret = this.handleBackgroundSize(cssValue, properties);
                    if (ret.isEmpty()) continue;
                    errors.addAll(ret);
                    continue;
                }
                if (cssName.equalsIgnoreCase("text-decoration")) {
                    this.handleTextDecoration(cssValue, properties);
                    continue;
                }
                if (cssName.equalsIgnoreCase("border-bottom")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorderBottom();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    properties.putAll(this.buildProperties(shortHand, errors));
                    continue;
                }
                if (cssName.equalsIgnoreCase("border-left")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorderLeft();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    properties.putAll(this.buildProperties(shortHand, errors));
                    continue;
                }
                if (cssName.equalsIgnoreCase("border-right")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorderRight();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    properties.putAll(this.buildProperties(shortHand, errors));
                    continue;
                }
                if (cssName.equalsIgnoreCase("border-top")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorderTop();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    properties.putAll(this.buildProperties(shortHand, errors));
                    continue;
                }
                if (cssName.equalsIgnoreCase("border")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorder();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    properties.putAll(this.buildProperties(shortHand, errors));
                    continue;
                }
                if (cssName.equalsIgnoreCase("border-width")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorderWidth();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    properties.putAll(this.buildProperties(shortHand, errors));
                    continue;
                }
                if (cssName.equalsIgnoreCase("border-color")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorderColor();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    properties.putAll(this.buildProperties(shortHand, errors));
                    continue;
                }
                if (cssName.equalsIgnoreCase("border-style")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorderStyle();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    properties.putAll(this.buildProperties(shortHand, errors));
                    continue;
                }
                if (cssName.equalsIgnoreCase("font")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseFont();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    properties.putAll(this.buildProperties(shortHand, errors));
                    continue;
                }
                if (cssName.equalsIgnoreCase("background")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBackground();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    properties.putAll(this.buildProperties(shortHand, errors));
                    continue;
                }
                if (cssName.equalsIgnoreCase("margin")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseMargin();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    properties.putAll(this.buildProperties(shortHand, errors));
                    continue;
                }
                if (cssName.equalsIgnoreCase("padding")) {
                    parser = new PropertyParser(cssValue);
                    parser.parsePadding();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    properties.putAll(this.buildProperties(shortHand, errors));
                    continue;
                }
                String name = CssPropertyUtil.getPropertyName(cssName);
                if (name == null) {
                    exception = new StyleSheetParserException("Error.StyleSheetParserException.PROPERTY_NOT_SUPPORTED", cssName, cssValue);
                    this.semanticWarning(exception);
                    errors.add(exception);
                    continue;
                }
                ElementPropertyDefn propDefn = (ElementPropertyDefn)this.style.getProperty(name);
                assert (propDefn != null);
                try {
                    String wrongValue = cssValue;
                    if (name.equalsIgnoreCase("backgroundImage")) {
                        cssValue = CssPropertyUtil.getURLValue(cssValue);
                    }
                    if (cssValue.equalsIgnoreCase("URL(-1)")) {
                        exception2 = new StyleSheetParserException("Error.StyleSheetParserException.INVALID_SIMPLE_CSSPROPERTY_VALUE", cssName, wrongValue);
                        this.semanticWarning(exception2);
                        errors.add(exception2);
                    }
                    Object value = propDefn.validateXml(this.module, cssValue);
                    properties.put(name, value);
                }
                catch (PropertyValueException e) {
                    exception2 = new StyleSheetParserException("Error.StyleSheetParserException.INVALID_SIMPLE_CSSPROPERTY_VALUE", cssName, cssValue, (Throwable)((Object)e));
                    this.semanticWarning(exception2);
                    errors.add(exception2);
                }
            }
            catch (ParseException e) {
                exception = new StyleSheetParserException("Error.StyleSheetParserException.INVALID_SHORT_HAND_CSSPROPERTY_VALUE", cssName, cssValue, (Throwable)e);
                this.semanticWarning(exception);
                errors.add(exception);
            }
            catch (CSSException e) {
                exception = new StyleSheetParserException("Error.StyleSheetParserException.INVALID_SHORT_HAND_CSSPROPERTY_VALUE", cssName, cssValue, (Throwable)e);
                this.semanticWarning(exception);
                errors.add(exception);
            }
        }
        return properties;
    }

    private List<StyleSheetParserException> handleBackgroundPosition(String cssValue, LinkedHashMap<String, Object> properties) {
        assert (cssValue != null);
        ArrayList<StyleSheetParserException> errors = new ArrayList<StyleSheetParserException>();
        String[] values = cssValue.split("[\\s]");
        String positionX = null;
        String positionY = null;
        switch (values.length) {
            case 0: {
                break;
            }
            case 1: {
                positionX = values[0].trim();
                break;
            }
            case 2: {
                positionX = values[0].trim();
                positionY = values[1].trim();
                break;
            }
            default: {
                StyleSheetParserException exception = new StyleSheetParserException("Error.StyleSheetParserException.INVALID_SHORT_HAND_CSSPROPERTY_VALUE", "background-position", cssValue);
                this.semanticWarning(exception);
                errors.add(exception);
            }
        }
        errors.addAll(this.handleBackgroundValue("background-position", "backgroundPositionX", positionX, properties));
        errors.addAll(this.handleBackgroundValue("background-position", "backgroundPositionY", positionY, properties));
        return errors;
    }

    private List<StyleSheetParserException> handleBackgroundSize(String cssValue, LinkedHashMap<String, Object> properties) {
        assert (cssValue != null);
        ArrayList<StyleSheetParserException> errors = new ArrayList<StyleSheetParserException>();
        String[] values = cssValue.split("[\\s]");
        String sizeWidth = null;
        String sizeHeight = null;
        switch (values.length) {
            case 0: {
                break;
            }
            case 1: {
                sizeWidth = values[0].trim();
                break;
            }
            case 2: {
                sizeWidth = values[0].trim();
                sizeHeight = values[1].trim();
                break;
            }
            default: {
                StyleSheetParserException exception = new StyleSheetParserException("Error.StyleSheetParserException.INVALID_SHORT_HAND_CSSPROPERTY_VALUE", "background-size", cssValue);
                this.semanticWarning(exception);
                errors.add(exception);
            }
        }
        errors.addAll(this.handleBackgroundValue("background-size", "backgroundSizeWidth", sizeWidth, properties));
        errors.addAll(this.handleBackgroundValue("background-size", "backgroundSizeHeight", sizeHeight, properties));
        return errors;
    }

    private List<StyleSheetParserException> handleBackgroundValue(String cssName, String backgroundProp, String backgroundValue, LinkedHashMap<String, Object> properties) {
        if (!StringUtil.isBlank(backgroundValue)) {
            ElementPropertyDefn propDefn = (ElementPropertyDefn)this.style.getProperty(backgroundProp);
            assert (propDefn != null);
            try {
                Object value = propDefn.validateXml(this.module, backgroundValue);
                properties.put(backgroundProp, value);
            }
            catch (PropertyValueException e) {
                StyleSheetParserException exception = new StyleSheetParserException("Error.StyleSheetParserException.INVALID_SIMPLE_CSSPROPERTY_VALUE", cssName, backgroundValue, (Throwable)((Object)e));
                this.semanticWarning(exception);
                ArrayList<StyleSheetParserException> errors = new ArrayList<StyleSheetParserException>();
                errors.add(exception);
                return errors;
            }
        }
        return Collections.emptyList();
    }

    private void handleTextDecoration(String cssValue, LinkedHashMap<String, Object> properties) {
        assert (cssValue != null);
        cssValue = cssValue.toLowerCase();
        String[] values = cssValue.split("[\\s]");
        int i = 0;
        while (i < values.length) {
            String value = values[i].trim();
            if (value.equalsIgnoreCase("line-through")) {
                properties.put("textLineThrough", "line-through");
            } else if (value.equalsIgnoreCase("overline")) {
                properties.put("textOverline", "overline");
            } else if (value.equalsIgnoreCase("underline")) {
                properties.put("textUnderline", "underline");
            }
            ++i;
        }
    }

    void addProperties(DesignElement style, LinkedHashMap<String, ? extends Object> properties) {
        for (Map.Entry<String, ? extends Object> entry : properties.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            style.setProperty(name, value);
        }
    }

    LinkedHashMap<String, String> trimProperties(LinkedHashMap<String, String> properties) {
        assert (properties != null);
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtil.isBlank(value)) continue;
            ret.put(key, value);
        }
        return ret;
    }

    void semanticWarning(StyleSheetParserException e) {
        this.warnings.add(e);
        logger.log(Level.WARNING, e.getMessage());
    }
}

