/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.importlistevaleur.handler;

import fr.inra.adonis.core.command.AbstractAdonisHandler;
import fr.inra.adonis.importgenerique.ui.ImportGeneriqueWizardWithErrorDialog;
import fr.inra.adonis.importgenerique.ui.importwizard.ImportWizard;
import fr.inra.adonis.importlistevaleur.builder.CreationListeValeurImportImpl;
import fr.inra.adonis.importlistevaleur.builder.ListeValeurColonnesRef;
import fr.inra.adonis.importlistevaleur.wizard.ListeValeurImportWizard;
import fr.inra.adonis.modeleMetier.projetDeSaisie.variables.ListeValeur;
import fr.inra.adonis.persistance.AbstractDAOFactory;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;

public class ImportListeValeurHandler
extends AbstractAdonisHandler {
    private CreationListeValeurImportImpl builder;
    private ListeValeurImportWizard wizard;
    private ImportGeneriqueWizardWithErrorDialog imprt;
    private final List<ListeValeur> listesbiblio = AbstractDAOFactory.getInstance().getSiteDAO().getBibliotheque().getListesvaleurs();

    protected boolean canExecute(List<EObject> selectedElements, ExecutionEvent event) {
        return this.getVerrouManager().verrouilleBibliotheque(this.shell);
    }

    protected boolean preExecution(List<EObject> selectedElements, ExecutionEvent event) {
        InputDialog dlg;
        this.builder = new CreationListeValeurImportImpl();
        this.wizard = new ListeValeurImportWizard(ListeValeurColonnesRef.getSetListeValeurColRef(), this.builder);
        this.imprt = new ImportGeneriqueWizardWithErrorDialog(this.shell, (ImportWizard)this.wizard);
        if (this.imprt.execute() && (dlg = new InputDialog(this.shell, "Importer une liste de Valeur", "Nom de la liste : ", this.builder.getListeValeur().getNom(), (IInputValidator)new ListNameValidator())).open() == 0) {
            this.builder.getListeValeur().setNom(dlg.getValue());
            return true;
        }
        return false;
    }

    protected void executeCommande(List<EObject> selectedElements, ExecutionEvent event) {
        this.imprt.attachToModel(this.shell);
    }

    protected Collection<? extends EObject> getObjectsToValidate() {
        return null;
    }

    class ListNameValidator
    implements IInputValidator {
        ListNameValidator() {
        }

        public String isValid(String newText) {
            for (ListeValeur existant : ImportListeValeurHandler.this.listesbiblio) {
                if (newText.isEmpty()) {
                    return "Nom invalide";
                }
                if (!newText.equals(existant.getNom())) continue;
                return "Une liste de valeurs porte d\u00c3\u00a9j\u00c3\u00a0 le m\u00c3\u00aame nom.";
            }
            return null;
        }
    }
}

