/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.importlistevaleur.wizard;

import fr.inra.adonis.modeleMetier.projetDeSaisie.variables.ListeValeur;
import fr.inra.adonis.persistance.AbstractDAOFactory;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ListeValeurInfoDialog
extends TitleAreaDialog {
    private final ListeValeur listeValeur;
    private Button okButton;
    private Button cancelButton;
    private Text nomListeText;
    private String importedNomListe;
    private final List<ListeValeur> listesbiblio;

    public ListeValeurInfoDialog(Shell parentShell, ListeValeur lv) {
        super(parentShell);
        this.listeValeur = lv;
        this.listesbiblio = AbstractDAOFactory.getInstance().getSiteDAO().getBibliotheque().getListesvaleurs();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Importation liste de valeurs");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        this.cancelButton.setEnabled(true);
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginWidth = 5;
        gridLayout.marginTop = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginLeft = 5;
        gridLayout.marginBottom = 5;
        container.setLayout((Layout)gridLayout);
        Label lblListeValeur = new Label(container, 0);
        lblListeValeur.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblListeValeur.setText("Liste de Valeur : ");
        this.nomListeText = new Text(container, 2048);
        GridData gd_text = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_text.widthHint = 267;
        this.nomListeText.setLayoutData((Object)gd_text);
        this.nomListeText.setEditable(true);
        this.addListeners();
        this.initialize();
        this.validate();
        return composite;
    }

    protected Point getInitialSize() {
        return new Point(554, 219);
    }

    private void addListeners() {
        this.nomListeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ListeValeurInfoDialog.this.validate();
            }
        });
    }

    private void initialize() {
        this.setMessage("Terminez l'import. Vous pouvez modifier le nom de la liste");
        this.nomListeText.setText(this.listeValeur.getNom());
    }

    private void validate() {
        if (this.okButton == null) {
            return;
        }
        if (this.verifNom(this.nomListeText.getText())) {
            this.okButton.setEnabled(true);
        }
        this.importedNomListe = this.nomListeText.getText();
        boolean result = this.verifNom(this.importedNomListe);
        this.okButton.setEnabled(result);
    }

    private boolean verifNom(String nom) {
        String errMss = "";
        boolean result = true;
        for (ListeValeur lvBib : this.listesbiblio) {
            if (!nom.equals(lvBib.getNom())) continue;
            errMss = "Ce nom existe d\u00c3\u00a9j\u00c3\u00a0 dans la biblioth\u00c3\u00a8que, veuillez le modifier.";
            result = false;
        }
        if (!result) {
            this.setErrorMessage(errMss);
        } else {
            this.setErrorMessage(null);
        }
        return result;
    }

    protected void okPressed() {
        this.listeValeur.setNom(this.nomListeText.getText());
        super.okPressed();
    }
}

