/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.IBreakpointOrganizer;
import org.eclipse.debug.ui.IBreakpointOrganizerDelegateExtension;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class BreakpointsViewer
extends CheckboxTreeViewer {
    public BreakpointsViewer(Tree tree) {
        super(tree);
    }

    public Item[] getSelectedItems() {
        return this.getSelection(this.getControl());
    }

    public Widget searchItem(Object element) {
        return this.findItem(element);
    }

    public void refreshItem(TreeItem item) {
        this.updateItem((Widget)item, item.getData());
    }

    public IBreakpoint[] getVisibleBreakpoints() {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        Object[] elements = ((ITreeContentProvider)this.getContentProvider()).getElements((Object)manager);
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < elements.length) {
            TreeItem item = (TreeItem)this.searchItem(elements[i]);
            if (item != null) {
                this.collectExpandedBreakpoints(item, list);
            }
            ++i;
        }
        return list.toArray(new IBreakpoint[list.size()]);
    }

    private void collectExpandedBreakpoints(TreeItem item, List list) {
        Object data = item.getData();
        if (data instanceof IBreakpoint) {
            list.add(data);
            return;
        }
        if (item.getExpanded()) {
            TreeItem[] items = item.getItems();
            int i = 0;
            while (i < items.length) {
                this.collectExpandedBreakpoints(items[i], list);
                ++i;
            }
        }
    }

    protected void setSelection(TreeItem item) {
        this.getTree().setSelection(new TreeItem[]{item});
        this.updateSelection(this.getSelection());
    }

    public BreakpointContainer getRemovableContainer(Item item) {
        TreePath path;
        if (item == null) {
            return null;
        }
        if (item.getData() instanceof IBreakpoint && (path = this.getTreePathFromItem(item)) != null) {
            IBreakpoint breakpoint = (IBreakpoint)path.getLastSegment();
            BreakpointContainer container = null;
            int i = path.getSegmentCount() - 2;
            while (i > -1) {
                container = (BreakpointContainer)((Object)path.getSegment(i));
                if (container.contains(breakpoint) && container.getOrganizer().canRemove(breakpoint, container.getCategory())) {
                    return container;
                }
                --i;
            }
        }
        return null;
    }

    public BreakpointContainer getAddableContainer(Item item) {
        Object element;
        TreePath path = this.getTreePathFromItem(item);
        if (path != null && (element = path.getLastSegment()) instanceof IBreakpoint) {
            BreakpointContainer container = null;
            IBreakpoint breakpoint = (IBreakpoint)element;
            int i = path.getSegmentCount() - 2;
            while (i > -1) {
                container = (BreakpointContainer)((Object)path.getSegment(i));
                if (container.contains(breakpoint) && container.getOrganizer().canAdd(breakpoint, container.getCategory())) {
                    return container;
                }
                --i;
            }
        }
        return null;
    }

    public boolean canDrag(Item[] items) {
        if (items == null) {
            return false;
        }
        if (items.length == 0) {
            return false;
        }
        int i = 0;
        while (i < items.length) {
            if (this.getRemovableContainer(items[i]) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void performDrag(Item[] items) {
        if (items == null) {
            return;
        }
        HashMap<BreakpointContainer, ArrayList<IBreakpoint>> containersToBreakpoints = new HashMap<BreakpointContainer, ArrayList<IBreakpoint>>();
        BreakpointContainer container = null;
        IBreakpoint breakpoint = null;
        int i = 0;
        while (i < items.length) {
            if (!items[i].isDisposed()) {
                breakpoint = (IBreakpoint)items[i].getData();
                container = this.getRemovableContainer(items[i]);
                if (container != null) {
                    ArrayList<IBreakpoint> list = (ArrayList<IBreakpoint>)containersToBreakpoints.get((Object)container);
                    if (list == null) {
                        list = new ArrayList<IBreakpoint>();
                        containersToBreakpoints.put(container, list);
                    }
                    list.add(breakpoint);
                }
            }
            ++i;
        }
        Iterator iterator = containersToBreakpoints.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            container = (BreakpointContainer)((Object)entry.getKey());
            List list = (List)entry.getValue();
            IBreakpointOrganizer organizer = container.getOrganizer();
            IBreakpoint[] breakpoints = list.toArray(new IBreakpoint[list.size()]);
            if (organizer instanceof IBreakpointOrganizerDelegateExtension) {
                IBreakpointOrganizerDelegateExtension extension = (IBreakpointOrganizerDelegateExtension)((Object)organizer);
                extension.removeBreakpoints(breakpoints, container.getCategory());
                continue;
            }
            int i2 = 0;
            while (i2 < breakpoints.length) {
                organizer.removeBreakpoint(breakpoints[i2], container.getCategory());
                ++i2;
            }
        }
    }

    public boolean canDrop(Item target, IStructuredSelection selection) {
        if (selection == null || target == null) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object currentObject = iter.next();
            if (currentObject instanceof IBreakpoint && this.checkAddableParentContainers(target, (IBreakpoint)currentObject)) continue;
            return false;
        }
        return true;
    }

    private boolean checkAddableParentContainers(Item target, IBreakpoint breakpoint) {
        BreakpointContainer container = null;
        TreePath path = this.getTreePathFromItem(target);
        if (path != null) {
            Object element = null;
            int i = path.getSegmentCount() - 1;
            while (i > -1) {
                element = path.getSegment(i);
                if (element instanceof BreakpointContainer && ((container = (BreakpointContainer)((Object)element)).contains(breakpoint) || !container.getOrganizer().canAdd(breakpoint, container.getCategory()))) {
                    return false;
                }
                --i;
            }
        }
        return true;
    }

    public boolean performDrop(Item target, IStructuredSelection selection) {
        BreakpointContainer container;
        if (target == null || selection == null) {
            return false;
        }
        IBreakpoint breakpoint = null;
        Object element = target.getData();
        BreakpointContainer breakpointContainer = container = element instanceof BreakpointContainer ? (BreakpointContainer)((Object)element) : this.getAddableContainer(target);
        if (container == null) {
            return false;
        }
        IBreakpointOrganizer organizer = container.getOrganizer();
        if (organizer instanceof IBreakpointOrganizerDelegateExtension) {
            IBreakpointOrganizerDelegateExtension extension = (IBreakpointOrganizerDelegateExtension)((Object)organizer);
            Object[] array = selection.toArray();
            IBreakpoint[] breakpoints = new IBreakpoint[array.length];
            System.arraycopy(array, 0, breakpoints, 0, array.length);
            extension.addBreakpoints(breakpoints, container.getCategory());
        } else {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                breakpoint = (IBreakpoint)iter.next();
                organizer.addBreakpoint(breakpoint, container.getCategory());
            }
        }
        this.expandToLevel(target.getData(), -1);
        return true;
    }

    public void refresh() {
        super.refresh();
        this.initializeCheckedState();
    }

    private void initializeCheckedState() {
        TreeItem[] items = this.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            this.updateCheckedState(items[i]);
            ++i;
        }
    }

    public void updateCheckedState(Object element) {
        Widget[] widgets = this.searchItems(element);
        int i = 0;
        while (i < widgets.length) {
            Widget widget = widgets[i];
            if (widget != null) {
                this.updateCheckedState((TreeItem)widget);
            }
            ++i;
        }
    }

    private Widget[] searchItems(Object element) {
        ArrayList list = new ArrayList();
        TreeItem[] items = this.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            this.findAllOccurrences(items[i], element, list);
            ++i;
        }
        return list.toArray(new Widget[0]);
    }

    private void findAllOccurrences(TreeItem item, Object element, ArrayList list) {
        if (element.equals(item.getData())) {
            list.add(item);
        }
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            this.findAllOccurrences(items[i], element, list);
            ++i;
        }
    }

    public void updateCheckedState(TreeItem item) {
        Object element = item.getData();
        if (element instanceof IBreakpoint) {
            try {
                item.setChecked(((IBreakpoint)element).isEnabled());
                this.refreshItem(item);
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        } else if (element instanceof BreakpointContainer) {
            IBreakpoint[] breakpoints = ((BreakpointContainer)((Object)element)).getBreakpoints();
            int enabledChildren = 0;
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                try {
                    if (breakpoint.isEnabled()) {
                        ++enabledChildren;
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
                ++i;
            }
            if (enabledChildren == 0) {
                item.setGrayed(false);
                item.setChecked(false);
            } else if (enabledChildren == breakpoints.length) {
                item.setGrayed(false);
                item.setChecked(true);
            } else {
                item.setGrayed(true);
                item.setChecked(true);
            }
            TreeItem[] items = item.getItems();
            int i2 = 0;
            while (i2 < items.length) {
                this.updateCheckedState(items[i2]);
                ++i2;
            }
        }
    }
}

