/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api.querydefn;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class Binding
implements IBinding {
    private List aggregateOn;
    private Map argument;
    private List orderedArgument;
    private IBaseExpression expr;
    private IBaseExpression filter;
    private String aggrFunc;
    private String name;
    private String displayName;
    private int dataType;
    private boolean exportable;

    public Binding(String name) {
        this(name, null);
    }

    public Binding(String name, IBaseExpression expr) {
        this.name = name;
        this.expr = expr;
        this.aggregateOn = new ArrayList();
        this.argument = new LinkedHashMap();
        this.orderedArgument = new ArrayList();
        this.dataType = expr != null ? expr.getDataType() : 0;
        this.exportable = true;
    }

    public void addAggregateOn(String levelName) throws DataException {
        if (!this.aggregateOn.contains(levelName)) {
            this.aggregateOn.add(levelName);
        }
    }

    public void addArgument(IBaseExpression expr) {
        if (expr != null) {
            this.orderedArgument.add(expr);
        }
    }

    public void addArgument(String name, IBaseExpression expr) {
        if ("Data Field".equals(name)) {
            this.argument.put("Expression", expr);
        } else {
            this.argument.put(name, expr);
        }
    }

    public String getAggrFunction() {
        return this.aggrFunc;
    }

    public List getAggregatOns() {
        return this.aggregateOn;
    }

    public List getArguments() throws DataException {
        if (this.aggrFunc == null) {
            return this.orderedArgument;
        }
        if (this.orderedArgument.size() > 0) {
            return this.orderedArgument;
        }
        IAggrFunction info = AggregationManager.getInstance().getAggregation(this.aggrFunc);
        if (info == null) {
            return this.orderedArgument;
        }
        IParameterDefn[] parameters = info.getParameterDefn();
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                IParameterDefn pInfo = parameters[i];
                if (this.argument.get(pInfo.getName()) != null) {
                    this.orderedArgument.add(this.argument.get(pInfo.getName()));
                }
                ++i;
            }
        }
        return this.orderedArgument;
    }

    public int getDataType() {
        return this.dataType;
    }

    public IBaseExpression getFilter() {
        return this.filter;
    }

    public void setAggrFunction(String functionName) {
        this.aggrFunc = functionName;
    }

    public void setDataType(int type) {
        this.dataType = type;
    }

    public void setExpression(IBaseExpression expr) {
        this.expr = expr;
    }

    public void setFilter(IBaseExpression expr) {
        this.filter = expr;
    }

    public String getBindingName() {
        return this.name;
    }

    public IBaseExpression getExpression() {
        return this.expr;
    }

    public String getDisplayName() throws DataException {
        return this.displayName == null ? this.name : this.displayName;
    }

    public void setDisplayName(String displayName) throws DataException {
        this.displayName = displayName;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Binding other = (Binding)obj;
        return this.name.equals(other.getBindingName());
    }

    public boolean exportable() throws DataException {
        return this.exportable;
    }

    public void setExportable(boolean exportable) throws DataException {
        this.exportable = exportable;
    }
}

