/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.dimension;

import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.util.DiskIndex;

public class Level
implements ILevel {
    private String name;
    private int[] keyDataType;
    private String[] keyColNames;
    private int[] attributeDataTypes;
    private String[] attributeColNames;
    private int size;
    private DiskIndex diskIndex = null;
    private static Logger logger = Logger.getLogger(Level.class.getName());

    public Level(IDocumentManager documentManager, ILevelDefn levelDef, int[] keyDataType, int[] attributeDataTypes, int size, DiskIndex diskIndex) throws IOException, DataException {
        Object[] params = new Object[]{documentManager, levelDef, keyDataType, attributeDataTypes, new Integer(size), diskIndex};
        logger.entering(Level.class.getName(), "Level", params);
        this.name = levelDef.getLevelName();
        this.setKeyDataType(keyDataType);
        this.setKeyColNames(levelDef.getKeyColumns());
        this.setAttributeDataTypes(attributeDataTypes);
        this.setAttributeColNames(levelDef.getAttributeColumns());
        this.setSize(size);
        this.setDiskIndex(diskIndex);
        logger.exiting(Level.class.getName(), "Level");
    }

    public int getKeyDataType(String keyName) {
        int i = 0;
        while (i < this.getKeyColNames().length) {
            if (this.getKeyColNames()[i].equals(keyName)) {
                return this.getKeyDataType()[i];
            }
            ++i;
        }
        return -1;
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return this.getSize();
    }

    public boolean equals(Object o) {
        Level other = (Level)o;
        return this.name.equals(other.name);
    }

    public void close() throws IOException {
    }

    public int getAttributeDataType(String attributeName) {
        int i = 0;
        while (i < this.getAttributeColNames().length) {
            if (this.getAttributeColNames()[i].equals(attributeName)) {
                return this.getAttributeDataTypes()[i];
            }
            ++i;
        }
        return -1;
    }

    public String[] getAttributeNames() {
        return this.getAttributeColNames();
    }

    public String[] getKeyNames() {
        return this.getKeyColNames();
    }

    void setKeyDataType(int[] keyDataType) {
        this.keyDataType = keyDataType;
    }

    int[] getKeyDataType() {
        return this.keyDataType;
    }

    void setKeyColNames(String[] keyColNames) {
        this.keyColNames = keyColNames;
    }

    String[] getKeyColNames() {
        return this.keyColNames;
    }

    void setAttributeDataTypes(int[] attributeDataTypes) {
        this.attributeDataTypes = attributeDataTypes;
    }

    int[] getAttributeDataTypes() {
        return this.attributeDataTypes;
    }

    void setAttributeColNames(String[] attributeColNames) {
        this.attributeColNames = attributeColNames;
    }

    String[] getAttributeColNames() {
        return this.attributeColNames;
    }

    void setSize(int size) {
        this.size = size;
    }

    int getSize() {
        return this.size;
    }

    void setDiskIndex(DiskIndex diskIndex) {
        this.diskIndex = diskIndex;
    }

    DiskIndex getDiskIndex() {
        return this.diskIndex;
    }
}

