/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.RepositoryLocationValidator;

public class DefaultMetadataURLValidator
extends RepositoryLocationValidator {
    protected int repoFlag = 0;

    public void setKnownRepositoriesFlag(int flag) {
        this.repoFlag = flag;
    }

    protected URI[] getKnownLocations() {
        URI[] knownRepositories;
        try {
            knownRepositories = ProvisioningUtil.getMetadataRepositories(this.repoFlag);
        }
        catch (ProvisionException provisionException) {
            knownRepositories = new URI[]{};
        }
        return knownRepositories;
    }

    public IStatus validateRepositoryLocation(URI location, boolean contactRepositories, IProgressMonitor monitor) {
        String locationString;
        IStatus localValidationStatus = RepositoryHelper.checkRepositoryLocationSyntax((URI)location);
        if (!(localValidationStatus.isOK() || (locationString = URIUtil.toUnencodedString((URI)location)).length() <= 0 || locationString.charAt(0) != '/' && locationString.charAt(0) != File.separatorChar)) {
            location = RepositoryHelper.localRepoURIHelper((URI)location);
            localValidationStatus = RepositoryHelper.checkRepositoryLocationSyntax((URI)location);
        }
        if (!localValidationStatus.isOK()) {
            return localValidationStatus;
        }
        URI[] knownRepositories = this.getKnownLocations();
        int i = 0;
        while (i < knownRepositories.length) {
            if (knownRepositories[i].equals(location)) {
                localValidationStatus = new Status(4, "org.eclipse.equinox.p2.ui", 3000, ProvUIMessages.AddRepositoryDialog_DuplicateURL, null);
                break;
            }
            ++i;
        }
        if (!localValidationStatus.isOK()) {
            return localValidationStatus;
        }
        if (contactRepositories) {
            return ProvisioningUtil.validateMetadataRepositoryLocation(location, monitor);
        }
        return localValidationStatus;
    }
}

