#########################
#auteur : Audrey Jacques-Gustave
#date : 08/10/2010
#algo : Tirage aléatoire des dispositifs à blocs complets
#référence : document Algo_softeam.doc (page 6)
#date de modification : 25/05/2011
#########################
# usage :
# Rscript algoBC_script.R val_B val_T file_output.csv emplacement_PNG/
#########################

## récupération des arguments
args <- commandArgs()
args <- args[match("--args", args): length(args)]
args <- args[-1]
#########################

source("affichage_dispositif.R")
########################
## définition de la fonction pour tester les variables en entrée de BC
# B:entier, nombre total de blocs
# T:entier, nombre total de traitements
test_entree_BC <- function(B,T){
  if(is.numeric(B)==FALSE||is.numeric(T)==FALSE){
    err_file<-file("error_BC.txt",open="wt")
    write(paste(format(Sys.time(),"%b %d %Y %H-%M-%S"),": Erreur pour B et/ou T: valeurs numériques attendues."),err_file)
    close(err_file)
    return(FALSE)
  }else{
    if(length(B)>1||length(T)>1){
    err_file<-file("error_BC.txt",open="at")
    write(paste(format(Sys.time(),"%b %d %Y %H-%M-%S"),": Erreur pour B et/ou T: une seule valeur de B et une seule valeur de T sont demandées."),err_file)
    return(FALSE)
    }else{
      return(TRUE)
    }
  }
}

##définition de la fonction "permute"##
#permute aléatoirement les éléments du vecteur V en respectant une organisation en blocs et sous-blocs
#t0: nombre de grands blocs(>= 1)
#t1: nombre de sous-blocs par grands blocs(se sont les entités à permuter intra grands blocs)
#t2: taille des sous-blocs (>= 1)
permute <- function(V,t0,t1,t2){
  Vperm <- matrix(V,nrow=t2,ncol=(t0*t1))
  for(j in 1:t0){
    Vperm[,t1*(j-1)+1:t1] <- Vperm[,t1*(j-1)+sample(t1)]
  }
  return(Vperm)
}

##définition de la fonction getDispositif
# B:entier, nombre total de blocs
# T:entier, nombre total de traitements
# file: chaîne de caractères, nom du fichier csv où le résultat sera sauvegardé
getDispositif_BC <- function(B,T,file,perso=""){
  ok <- test_entree_BC(B,T)
  if(ok==FALSE){
    print("Erreur, variables en entree sont incorrectes. Voir détail dans le fichier error_BC.txt")
    return(FALSE)
  }
  
  K <- T
  N <- K*B

  ##mise en place de la structure de base
  sAdonis <- expand.grid(PU=1:K,Bloc=1:B)
  sAdonis <- cbind(sAdonis, expand.grid(X=1:K,Y=1:B),m1=rep(0,N), m2=rep(0,N),m3=rep(0,N),"Sous-bloc"=rep(0,N),Trt=1:T)
  sAdonis <- sAdonis[,c("Bloc","Sous-bloc","PU","Trt","m1","m2","m3","X","Y")]

  nU <- 1:N
  nUr <- nU
  ##randomisation des Pus dans les blocs

  nUr <- permute(nUr,B,K,1)
  nUr <- c(nUr)

  ##randomisation des blocs entre eux
  nUr <- permute(nUr,1,B,K)
  nUr <- c(nUr)

  sAdonis[,c("Trt")]<- sAdonis[nUr,c("Trt")]
  
  
  ##écriture dans le fichier
  write.table(sAdonis,file,row.names=FALSE,sep=";")
  dispo <- read.table(file,header=TRUE,sep=";")
  affiche_dispositif(dispo,paste(perso,"BC_",format(Sys.time(),"%b_%d_%Y_%H%M%S"),".png",sep=""),"Bloc Complet")

}

## affectation des arguments
B <- as.numeric(args[1])
T <- as.numeric(args[2])
file <- args[3]
if(length(args)>3){
  direct <- args[4]
}else{
  direct <- ""
}

## appel de la fonction
getDispositif_BC(B,T,file,perso=direct)


