#########################
#auteur : Audrey Jacques-Gustave Palain-Saint-Agathe
#date : 15/10/2010
#algo : Tirage aléatoire des dispositifs en split-plot 2 facteurs et 3 facteurs indépendants
#référence : document Algo_softeam.doc (pages 8 et 11)
#dernière modification : 04/01/2021
#########################
# usage :
# Rscript algoSplitPlot_script.R nbM1,nbM2,... nbBloc fichier_modalités_facteurs.dat fichier_sortie.csv emplacement_PNG/
#########################
## récupération des arguments
args <- commandArgs()
args <- args[match("--args", args): length(args)]
args <- args[-1]
#########################

source("affichage_dispositif.R")
########################
## définition de la fonction pour le Split-Plot
# VectMF : chaîne de caractères, liste des nombres de modalités pour chaque facteurs (maximum 3)
# B : entier, nombre de blocs
# file : chaîne de caractères, nom du fichier de sortie
# perso : chaîne de caractères pour personnaliser le nom du fichier png
test_entree_SplitPlot <- function(VectMF,B){
  if(is.character(VectMF)==FALSE){
    err_file <- file("error_SplitPlot.txt", open="wt")
    write(paste(format(Sys.time(),"%b %d %Y %H-%M-%S"),": Erreur Chaîne de caractères attendue en entrée"),file=err_file)
    close(err_file)
    return(FALSE)
  }else{
    VectMF <- unlist(strsplit(VectMF,","))
    if(length(VectMF)>3){
      err_file <- file("error_SplitPlot.txt", open="at")
      write(paste(format(Sys.time(),"%b %d %Y %H-%M-%S"),": Erreur le nombre de facteur doit être égal à 2 ou à 3"),file=err_file)
      close(err_file)
      return(FALSE)
    }else{
      return(TRUE)
    }
  }
}
getDispositif_SplitPlot <- function(VectMF,B,matFile,file,perso=""){
  arg_ok <- test_entree_SplitPlot(VectMF,B)
  mat <- read.table(matFile,sep=";",header=TRUE)
  if(arg_ok== TRUE){
    VectMF <- unlist(strsplit(VectMF,","))
    if(length(VectMF)==2){
      getDispositif_SplitPlot2F(VectMF[1],VectMF[2],B,mat,file)
      dispo <- read.table(file,header=TRUE,sep=";")
      affiche_dispositif(dispo,paste(perso,"splitplot_",format(Sys.time(),"%b_%d_%Y_%H%M%S"),".png",sep=""),"SPlit Plot (2 facteurs ou 3 facteurs dont 2 liés)")
    }
    else{
      if (length(VectMF)==3){
	getDispositif_SplitPlot3F_inde(VectMF[1],VectMF[2],VectMF[3],B,mat,file)
	dispo <- read.table(file,header=TRUE,sep=";")
	affiche_dispositif(dispo,paste(perso,"splitplot_",format(Sys.time(),"%b_%d_%Y_%H%M%S"),".png",sep=""),"Split Plot (3 facteurs indépendants)")
      }
      
    }
  }else{
    print("Erreur: variables en entrée sont incorrectes. Voir détail dans le fichier error_SplitPlot.txt")
    return(FALSE)
  }
}


##définition de la fonction "permute"##
#permute aléatoirement les éléments du vecteur V en respectant une organisation en blocs et sous-blocs
#t0: nombre de grands blocs(>= 1)
#t1: nombre de sous-blocs par grands blocs(se sont les entités à permuter intra grands blocs)
#t2: taille des sous-blocs (>= 1)
permute <- function(V,t0,t1,t2){
  Vperm <- matrix(V,nrow=t2,ncol=(t0*t1))
  for(j in 1:t0){
    Vperm[,t1*(j-1)+1:t1] <- Vperm[,t1*(j-1)+sample(t1)]
  }
  return(Vperm)
}

##définition de la fonction SplitPlot2F
#Mfsb : nombre de modalités distribuées dans les sous-blocs
#Mfpu : nombre de modalités distribuées dans les parcelles unitaires
#B : nombre de blocs
#mat : matrice de traitements
#file : fichier csv où sera enregistré le résultat
getDispositif_SplitPlot2F <- function(Mfsb,Mfpu,B,mat,file){
  ## création de la structure de base
  Mfsb <- as.numeric(Mfsb)
  Mfpu <- as.numeric(Mfpu)
  N <- Mfsb*Mfpu*B
  K <-  Mfpu*Mfsb
  sAdonis <- expand.grid(PU=1:Mfpu,"Sous-bloc"=1:Mfsb,Bloc=1:B)
  sAdonis <- sAdonis[,c("Bloc","Sous-bloc","PU")]
  sAdonis <- cbind(sAdonis,Trt=mat$Trt,m1=mat$m1,m2=mat$m2,m3=mat$m3)
  sAdonis <- cbind(sAdonis,expand.grid(X=1:K,Y=1:B))
  #M <- cbind(M,cbind(expand.grid(m3=1:Mfpu3,m2=1:Mfpu2,m1=1:Mfsb),Trt=rep(1:(Mfsb*Mfpu2*Mfpu3),B)))

 # browser()
  ##randomisation des PUs au sein des sous blocs

  nU <- 1:N
  nUr <- nU

  ##randomisation des PUs au sein des sous-blocs
  nUr <- permute(nUr,Mfsb*B,Mfpu,1)
  nUr <- c(nUr)
  ##randomisation des Sous-blocs au sein des blocs

  nUr <- permute(nUr,B,Mfsb,Mfpu)
  nUr <- c(nUr)
  ##randomisation des blocs entre eux

  nUr <- permute(nUr,1,B,Mfsb*Mfpu)
  nUr <- c(nUr)

  ##On réintègre les traitements randomisés dans la structure de base
  sAdonis[,c("Trt","m1","m2","m3")] <- sAdonis[nUr,c("Trt","m1","m2","m3")]
  sAdonis<- sAdonis[,c("Bloc","Sous-bloc","PU","Trt","m1","m2","m3","X","Y")]
  
	
  ##écriture dans le fichier
  write.table(sAdonis, file,row.names=FALSE,sep=";")
  return(sAdonis)
}

getDispositif_SplitPlot3F_inde<- function(Mf1,Mf2,Mf3,B,mat,file){
  
   Mf1 <- as.numeric(Mf1)
   Mf2 <- as.numeric(Mf2)
   Mf3 <- as.numeric(Mf3)
   N <- Mf1*Mf2*Mf3*B
   K <- Mf1*Mf2*Mf3
   sAdonis <- expand.grid(PU=1:(Mf2*Mf3),"Sous-bloc"=1:Mf1,Bloc=1:B)
   

   sAdonis <- sAdonis[,c("Bloc","Sous-bloc","PU")]
   sAdonis <- cbind(sAdonis,Trt=mat$Trt,m1=mat$m1,m2=mat$m2,m3=mat$m3)


   ##randomisation des PUs au sein des sous-sous blocs
   
   nU <- 1:N
   nUr <- nU

   nUr <- permute(nUr,Mf1*Mf2*B,Mf3,1)
   nUr <- c(nUr)

   ##randomisation des sous-sous blocs dans les sous blocs
   nUr <- permute(nUr,Mf1*B,Mf2,Mf3)
   nUr <- c(nUr)

   ##randomisation des sous-blocs dans les blocs
   nUr <- permute(nUr,B,Mf1,Mf2*Mf3)
   nUr <- nUr

   ##randomisation des blocs entre eux
   nUr <- permute(nUr,1,B,Mf1*Mf2*Mf3)
   nUr <- nUr

   ##On réintègre les traitements randomisés dans la structure de base
   sAdonis[,c("Trt","m1","m2","m3")] <- sAdonis[nUr,c("Trt","m1","m2","m3")]
   sAdonis <- cbind(sAdonis,expand.grid(X=1:K,Y=1:B))
 
 
   ## sauvegarde du dispositif dans un fichier format csv
   write.table(sAdonis,file,row.names=FALSE,sep=";")
   return(sAdonis)
  
}
## affectation des arguments
VectMF <- args[1]
B <- as.numeric(args[2])
matFile <- args[3]
file <- args[4]
if(length(args)>4){
  direct <- args[5]
}else{
  direct <- ""
}

## appel de la fonction
getDispositif_SplitPlot(VectMF,B,matFile,file,perso=direct)
